/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.nbt;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={CompoundTag.class})
public abstract class CompoundTagMixin {
    @Shadow
    @Final
    private Map<String, Tag> tags;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Redirect(method={"copy()Lnet/minecraft/nbt/CompoundTag;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/Tag;copy()Lnet/minecraft/nbt/Tag;"))
    @Nullable
    private Tag impl$checkForOverflowOnCopy(Tag inbt) {
        try {
            if (inbt == null) {
                return null;
            }
            Tag tag = inbt.copy();
            return tag;
        }
        catch (StackOverflowError e) {
            PrettyPrinter printer = new PrettyPrinter(60).add("StackOverflow from trying to copy this compound").centre().hr();
            printer.addWrapped(70, "Sponge caught a stack overflow error, printing out some special handling and printouts to assist in finding out where this recursion is coming from.", new Object[0]);
            printer.add();
            try {
                printer.addWrapped(80, "%s : %s", "This compound", this);
            }
            catch (Throwable error) {
                printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
                    try {
                        printer.addWrapped(80, "%s : %s", entry.getKey(), entry.getValue());
                    }
                    catch (Throwable throwable) {
                        printer.add();
                        printer.addWrapped(80, "The offending key entry is belonging to " + entry.getKey(), new Object[0]);
                        break;
                    }
                }
            }
            printer.add();
            printer.log(SpongeCommon.logger(), Level.ERROR);
            return null;
        }
    }

    @Redirect(method={"copy()Lnet/minecraft/nbt/CompoundTag;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;put(Ljava/lang/String;Lnet/minecraft/nbt/Tag;)Lnet/minecraft/nbt/Tag;"))
    private Tag impl$checkForNullNBTValuesDuringCopy(CompoundTag compound, String key, Tag value) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("There is a null NBT component in the compound for key: " + key);
            SpongeCommon.logger().error("Printing out a stacktrace to catch an exception in performing an NBTTagCompound.copy!\nIf you are seeing this, then Sponge is preventing an exception from being thrown due to unforseen\npossible bugs in any mods present. Please report this to SpongePowered and/or the relative mod\nauthors for the offending compound data!", (Throwable)exception);
        } else {
            compound.put(key, value);
        }
        return value;
    }
}

