/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.util.Constants;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin
extends SimpleChannelInboundHandler<Packet<?>>
implements ConnectionBridge {
    @Shadow
    private PacketListener packetListener;
    @Shadow
    private Channel channel;
    private final TransactionStore impl$transactionStore = new TransactionStore(() -> (EngineConnection)this.packetListener);
    private final Set<ResourceKey> impl$registeredChannels = Sets.newConcurrentHashSet();
    @Nullable
    private InetSocketAddress impl$virtualHost;
    @Nullable
    private MinecraftVersion impl$version;
    @Nullable
    private Component impl$kickReason;
    private ClientType impl$clientType = ClientType.VANILLA;

    @Shadow
    public abstract SocketAddress getRemoteAddress();

    @Override
    public TransactionStore bridge$getTransactionStore() {
        return this.impl$transactionStore;
    }

    @Override
    public Set<ResourceKey> bridge$getRegisteredChannels() {
        return this.impl$registeredChannels;
    }

    @Override
    public ClientType bridge$getClientType() {
        return this.impl$clientType;
    }

    @Override
    public void bridge$setClientType(ClientType clientType) {
        this.impl$clientType = clientType;
    }

    @Override
    public InetSocketAddress bridge$getAddress() {
        SocketAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress bridge$getVirtualHost() {
        if (this.impl$virtualHost != null) {
            return this.impl$virtualHost;
        }
        SocketAddress local = this.channel.localAddress();
        if (local instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void bridge$setVirtualHost(String host, int port) {
        try {
            this.impl$virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.channel.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.impl$virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    @Nullable
    public Component bridge$getKickReason() {
        return this.impl$kickReason;
    }

    @Override
    public void bridge$setKickReason(Component component) {
        this.impl$kickReason = component;
    }

    @Override
    public MinecraftVersion bridge$getVersion() {
        return this.impl$version;
    }

    @Override
    public void bridge$setVersion(int version) {
        this.impl$version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }

    @Inject(method={"lambda$doSendPacket$8"}, at={@At(value="INVOKE", target="Lio/netty/util/concurrent/Future;isSuccess()Z")})
    public void impl$onPacketSent(PacketSendListener $$0x, Future $$1x, CallbackInfo ci) {
        if ($$0x instanceof PacketSender.SpongePacketSendListener) {
            PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$0x;
            spongeListener.accept($$1x);
        }
    }
}

