/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.item.PrimedTntBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={TntBlock.class})
public abstract class TntBlockMixin
extends BlockMixin {
    private boolean primeCancelled;

    private boolean impl$onRemove(Level world, BlockPos pos, boolean isMoving) {
        boolean removed = !this.primeCancelled && world.removeBlock(pos, isMoving);
        this.primeCancelled = false;
        return removed;
    }

    @Inject(method={"explode(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private static void impl$ThrowPrimeAndMaybeCancel(Level worldIn, BlockPos pos, @Nullable LivingEntity igniter, CallbackInfo ci, PrimedTnt tnt) {
        ((PrimedTntBridge)tnt).bridge$setDetonator(igniter);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                if (igniter != null) {
                    frame.addContext(EventContextKeys.IGNITER, (Living)igniter);
                }
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"wasExploded"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$CheckIfCanPrimeFromExplosion(Level worldIn, BlockPos pos, Explosion explosionIn, CallbackInfo ci, PrimedTnt tnt) {
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.DAMAGE_TYPE, DamageTypes.EXPLOSIVE);
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Redirect(method={"onPlace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z"))
    private boolean impl$removePostSetAir(Level world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }

    @Redirect(method={"neighborChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z"))
    private boolean impl$removeNeighbor(Level world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"))
    private boolean impl$removeActivated(Level world, BlockPos pos, BlockState state, int flag) {
        boolean removed = !this.primeCancelled && world.setBlock(pos, state, flag);
        this.primeCancelled = false;
        return removed;
    }

    @Redirect(method={"onProjectileHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z"))
    private boolean impl$removeonCollide(Level world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }
}

