/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.carrier.BrewingStand;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.BrewingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={BrewingStandBlockEntity.class})
public class BrewingStandBlockEntityMixin {
    @Shadow
    int brewTime;
    @Shadow
    int fuel;
    @Shadow
    private NonNullList<ItemStack> items;
    @Shadow
    private Item ingredient;

    @Inject(method={"serverTick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;isBrewable(Lnet/minecraft/core/NonNullList;)Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;setChanged(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private static void impl$onConsumeFuel(Level param0, BlockPos param1, BlockState param2, BrewingStandBlockEntity param3, CallbackInfo ci, ItemStack fuelStack) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        fuelStack.grow(1);
        ItemStackSnapshot originalStack = ItemStackUtil.snapshotOf(fuelStack);
        fuelStack.shrink(1);
        Transaction<ItemStackSnapshot> fuelTransaction = new Transaction<ItemStackSnapshot>(originalStack, ItemStackUtil.snapshotOf(fuelStack));
        ItemStackSnapshot ingredientStack = ItemStackUtil.snapshotOf((ItemStack)((BrewingStandBlockEntityMixin)param3).items.get(3));
        BrewingEvent.ConsumeFuel event = SpongeEventFactory.createBrewingEventConsumeFuel(currentCause, (BrewingStand)param3, fuelTransaction, ingredientStack);
        if (Sponge.eventManager().post(event)) {
            fuelStack.grow(1);
            ((BrewingStandBlockEntityMixin)param3).fuel = 0;
        } else if (event.fuel().custom().isPresent()) {
            ItemStackSnapshot finalFuel = event.fuel().finalReplacement();
            ((BrewingStandBlockEntityMixin)param3).items.set(4, (Object)ItemStackUtil.fromSnapshotToNative(finalFuel));
        }
    }

    @Inject(method={"serverTick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;isBrewable(Lnet/minecraft/core/NonNullList;)Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;setChanged(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private static void impl$callBrewEvents(Level param0, BlockPos param1, BlockState param2, BrewingStandBlockEntity param3, CallbackInfo ci, ItemStack fuelStack, boolean isBrewable, boolean isBrewing, ItemStack ingredientStack) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        if (isBrewing) {
            if (((BrewingStandBlockEntityMixin)param3).brewTime == 0 && isBrewable) {
                ArrayList<ItemStackSnapshot> stacks = new ArrayList<ItemStackSnapshot>();
                for (int i = 0; i < 3; ++i) {
                    stacks.add(ItemStackUtil.snapshotOf((ItemStack)((BrewingStandBlockEntityMixin)param3).items.get(i)));
                }
                BrewingEvent.Finish event = SpongeEventFactory.createBrewingEventFinish(currentCause, Collections.unmodifiableList(stacks), (BrewingStand)param3, ItemStackUtil.snapshotOf(ingredientStack));
                Sponge.eventManager().post(event);
            } else if (!isBrewable || ((BrewingStandBlockEntityMixin)param3).ingredient != ingredientStack.getItem()) {
                BrewingEvent.Interrupt event = SpongeEventFactory.createBrewingEventInterrupt(currentCause, (BrewingStand)param3, ItemStackUtil.snapshotOf(ingredientStack));
                Sponge.eventManager().post(event);
            }
        } else if (isBrewable && ((BrewingStandBlockEntityMixin)param3).fuel > 0) {
            BrewingEvent.Start event = SpongeEventFactory.createBrewingEventStart(currentCause, (BrewingStand)param3, ItemStackUtil.snapshotOf(ingredientStack));
            if (Sponge.eventManager().post(event)) {
                ((BrewingStandBlockEntityMixin)param3).brewTime = 0;
                ((BrewingStandBlockEntityMixin)param3).ingredient = Items.AIR;
                ++((BrewingStandBlockEntityMixin)param3).fuel;
            }
        }
    }

    @Inject(method={"serverTick"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;brewTime:I", ordinal=1)})
    private static void impl$onTick(Level param0, BlockPos param1, BlockState param2, BrewingStandBlockEntity param3, CallbackInfo ci, ItemStack fuelStack, boolean isBrewable, boolean isBrewing, ItemStack ingredientStack) {
        if (((BrewingStandBlockEntityMixin)param3).brewTime != 0 && isBrewable && ((BrewingStandBlockEntityMixin)param3).ingredient == ingredientStack.getItem()) {
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            BrewingEvent.Tick event = SpongeEventFactory.createBrewingEventTick(currentCause, (BrewingStand)param3, ItemStackUtil.snapshotOf(ingredientStack));
            if (Sponge.eventManager().post(event)) {
                ++((BrewingStandBlockEntityMixin)param3).brewTime;
            }
        }
    }
}

