/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.scores;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.scores.PlayerTeamBridge;

@Mixin(value={PlayerTeam.class})
public abstract class PlayerTeamMixin
implements PlayerTeamBridge {
    @Shadow
    @Final
    @Mutable
    private @Nullable Scoreboard scoreboard;
    @Shadow
    private Component displayName;
    @Shadow
    private ChatFormatting color;
    @Shadow
    private Component playerPrefix;
    @Shadow
    private Component playerSuffix;
    private @MonotonicNonNull net.kyori.adventure.text.Component bridge$displayName;
    private @MonotonicNonNull net.kyori.adventure.text.Component bridge$prefix;
    private @MonotonicNonNull net.kyori.adventure.text.Component bridge$suffix;
    private @MonotonicNonNull NamedTextColor bridge$color;

    @Shadow
    public abstract Collection<String> getPlayers();

    private void impl$teamChanged() {
        if (this.scoreboard != null) {
            this.scoreboard.onTeamChanged((PlayerTeam)this);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpDisplayNames(Scoreboard scoreboard, String name, CallbackInfo ci) {
        this.bridge$displayName = LegacyComponentSerializer.legacySection().deserialize(name);
        this.bridge$prefix = SpongeAdventure.asAdventure(this.playerPrefix);
        this.bridge$suffix = SpongeAdventure.asAdventure(this.playerSuffix);
        this.bridge$color = SpongeAdventure.asAdventureNamed(this.color);
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/scores/Scoreboard;onTeamChanged(Lnet/minecraft/world/scores/PlayerTeam;)V"))
    private void impl$nullCheckScoreboard(@Nullable Scoreboard scoreboard, PlayerTeam team) {
        if (scoreboard != null) {
            scoreboard.onTeamChanged(team);
        }
    }

    @Inject(method={"setDisplayName"}, at={@At(value="FIELD", target="Lnet/minecraft/world/scores/PlayerTeam;displayName:Lnet/minecraft/network/chat/Component;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$trackDisplayNameChange(Component name, CallbackInfo ci) {
        this.bridge$displayName = SpongeAdventure.asAdventure(name);
    }

    @Inject(method={"setPlayerPrefix"}, at={@At(value="FIELD", target="Lnet/minecraft/world/scores/PlayerTeam;playerPrefix:Lnet/minecraft/network/chat/Component;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$trackPrefixChange(Component prefix, CallbackInfo callbackInfo) {
        this.bridge$prefix = SpongeAdventure.asAdventure(prefix);
    }

    @Inject(method={"setPlayerSuffix"}, at={@At(value="FIELD", target="Lnet/minecraft/world/scores/PlayerTeam;playerSuffix:Lnet/minecraft/network/chat/Component;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$trackSuffixChange(Component suffix, CallbackInfo ci) {
        this.bridge$suffix = SpongeAdventure.asAdventure(suffix);
    }

    @Inject(method={"setColor"}, at={@At(value="RETURN")})
    private void impl$trackColorChange(ChatFormatting color, CallbackInfo ci) {
        this.bridge$color = SpongeAdventure.asAdventureNamed(color);
    }

    @Override
    public net.kyori.adventure.text.Component bridge$getDisplayName() {
        return this.bridge$displayName;
    }

    @Override
    public void bridge$setDisplayName(net.kyori.adventure.text.Component text) {
        this.bridge$displayName = text;
        this.displayName = SpongeAdventure.asVanilla(text);
        this.impl$teamChanged();
    }

    @Override
    public net.kyori.adventure.text.Component bridge$getPrefix() {
        return this.bridge$prefix;
    }

    @Override
    public void bridge$setPrefix(net.kyori.adventure.text.Component text) {
        this.bridge$prefix = text;
        this.playerPrefix = SpongeAdventure.asVanilla(text);
        this.impl$teamChanged();
    }

    @Override
    public net.kyori.adventure.text.Component bridge$getSuffix() {
        return this.bridge$suffix;
    }

    @Override
    public void bridge$setSuffix(net.kyori.adventure.text.Component suffix) {
        this.bridge$suffix = suffix;
        this.playerSuffix = SpongeAdventure.asVanilla(suffix);
        this.impl$teamChanged();
    }

    @Override
    public NamedTextColor bridge$getColor() {
        return this.bridge$color;
    }

    @Override
    public void bridge$setColor(NamedTextColor color) {
        this.bridge$color = color;
        this.color = SpongeAdventure.asVanilla(color);
        this.impl$teamChanged();
    }

    @Override
    public Audience bridge$getTeamChannel(ServerPlayer player) {
        return Audience.audience((Iterable)this.getPlayers().stream().map(name -> Sponge.game().server().player((String)name)).filter(Optional::isPresent).map(Optional::get).filter(member -> member != player).collect(Collectors.toSet()));
    }

    @Override
    public Audience bridge$getNonTeamChannel() {
        return Audience.audience((Iterable)Sponge.game().server().onlinePlayers().stream().filter(player -> ((ServerPlayer)player).getTeam() != this).collect(Collectors.toSet()));
    }
}

