/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.world.entity;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.entitycollision.entity.EntityMixin_EntityCollision;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_EntityCollision
extends EntityMixin_EntityCollision {
    private boolean runningCollideWithNearby = false;

    @Shadow
    protected abstract void shadow$doPush(Entity var1);

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;pushEntities()V")})
    private void collisions$canUpdateCollisions(CallbackInfo ci) {
        this.runningCollideWithNearby = true;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;pushEntities()V", shift=At.Shift.AFTER)})
    private void collisions$resetCanUpdateCollisions(CallbackInfo ci) {
        this.runningCollideWithNearby = false;
    }

    @Override
    public boolean collision$isRunningCollideWithNearby() {
        return this.runningCollideWithNearby;
    }

    @Redirect(method={"pushEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I", remap=false))
    private int collisions$pushEntities(List<Entity> list) {
        for (Entity entity : list) {
            if (this.shadow$getCommandSenderWorld().isClientSide() || entity == null || entity instanceof Player || entity instanceof EnderDragon) continue;
            if (this.collision$requiresCollisionsCacheRefresh()) {
                this.collision$initializeCollisionState(this.shadow$getCommandSenderWorld());
                this.collision$requiresCollisionsCacheRefresh(false);
            }
            if (this.collision$getMaxCollisions() >= 0 && list.size() >= this.collision$getMaxCollisions()) break;
            this.shadow$doPush(entity);
        }
        return 0;
    }
}

