/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={EnchantmentMenu.class})
public abstract class EnchantmentContainerMixin_Inventory {
    @Shadow
    @Final
    private DataSlot enchantmentSeed;
    @Shadow
    @Final
    private net.minecraft.world.Container enchantSlots;
    private ItemStackSnapshot prevItem;
    private ItemStackSnapshot prevLapis;

    @Redirect(method={"lambda$slotsChanged$0"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantmentCost(Lnet/minecraft/util/RandomSource;IILnet/minecraft/world/item/ItemStack;)I"), require=1)
    private int impl$onCalcItemStackEnchantability(RandomSource random, int option, int power, ItemStack itemStack) {
        int levelRequirement = EnchantmentHelper.getEnchantmentCost((RandomSource)random, (int)option, (int)power, (ItemStack)itemStack);
        levelRequirement = InventoryEventFactory.callEnchantEventLevelRequirement((EnchantmentMenu)this, this.enchantmentSeed.get(), option, power, itemStack, levelRequirement);
        return levelRequirement;
    }

    @Inject(method={"getEnchantmentList"}, cancellable=true, at={@At(value="RETURN")})
    private void impl$onBuildEnchantmentList(ItemStack stack, int enchantSlot, int level, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        List<EnchantmentInstance> newList = InventoryEventFactory.callEnchantEventEnchantmentList((EnchantmentMenu)this, this.enchantmentSeed.get(), stack, enchantSlot, level, (List)cir.getReturnValue());
        if (cir.getReturnValue() != newList) {
            cir.setReturnValue(newList);
        }
    }

    @Inject(method={"lambda$clickMenuButton$1"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onEnchantmentPerformed(Lnet/minecraft/world/item/ItemStack;I)V")}, require=1)
    private void impl$beforeEnchantItem(CallbackInfo ci) {
        this.prevItem = ItemStackUtil.snapshotOf(this.enchantSlots.getItem(0));
        this.prevLapis = ItemStackUtil.snapshotOf(this.enchantSlots.getItem(1));
    }

    @Inject(method={"lambda$clickMenuButton$1"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;)V")}, require=1)
    private void impl$afterEnchantItem(ItemStack itemstack, int id, Player playerIn, int i, ItemStack itemstack1, Level arg5, BlockPos arg6, CallbackInfo ci) {
        Slot slotLapis;
        ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(this.enchantSlots.getItem(0));
        ItemStackSnapshot newLapis = ItemStackUtil.snapshotOf(this.enchantSlots.getItem(1));
        Container container = ContainerUtil.fromNative((AbstractContainerMenu)this);
        Slot slotItem = ((InventoryAdapter)((Object)container)).inventoryAdapter$getSlot(0).get();
        EnchantItemEvent.Post event = InventoryEventFactory.callEnchantEventEnchantPost(playerIn, (EnchantmentMenu)this, new SlotTransaction(slotItem, this.prevItem, newItem), new SlotTransaction(slotLapis = ((InventoryAdapter)((Object)container)).inventoryAdapter$getSlot(1).get(), this.prevLapis, newLapis), id, this.enchantmentSeed.get());
        if (event.isCancelled()) {
            ci.cancel();
        }
    }
}

