/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server;

import java.util.function.BooleanSupplier;
import net.minecraft.SystemReport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.event.tracking.CauseTrackerCrashHandler;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.DelayedTaskPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.event.tracking.phase.tick.ServerTickState;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.WorldTickState;
import org.spongepowered.common.mixin.tracker.util.thread.BlockableEventLoopMixin_Tracker;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin_Tracker
extends BlockableEventLoopMixin_Tracker {
    @Shadow
    public abstract boolean shadow$isStopped();

    @Shadow
    public abstract void shadow$tickChildren(BooleanSupplier var1);

    @Inject(method={"fillSystemReport"}, at={@At(value="RETURN")}, cancellable=true)
    private void tracker$addPhaseTrackerToCrashReport(SystemReport category, CallbackInfoReturnable<SystemReport> cir) {
        category.setDetail("Sponge PhaseTracker", CauseTrackerCrashHandler.INSTANCE::call);
    }

    @Inject(method={"tickServer"}, at={@At(value="RETURN")})
    private void tracker$ensurePhaseTrackerEmpty(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        PhaseTracker.SERVER.ensureEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tickServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickChildren(Ljava/util/function/BooleanSupplier;)V"))
    private void tracker$wrapUpdateTimeLightAndEntities(MinecraftServer minecraftServer, BooleanSupplier hasTimeLeft) {
        try (@NonNull ServerTickState.ServerTickContext context = TickPhase.Tick.SERVER_TICK.createPhaseContext(PhaseTracker.SERVER).server(minecraftServer);){
            context.buildAndSwitch();
            this.shadow$tickChildren(hasTimeLeft);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tickChildren"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;tick(Ljava/util/function/BooleanSupplier;)V"))
    private void tracker$wrapWorldTick(ServerLevel serverWorld, BooleanSupplier hasTimeLeft) {
        try (@NonNull WorldTickState.WorldTickContext context = TickPhase.Tick.WORLD_TICK.createPhaseContext(PhaseTracker.SERVER).world(serverWorld);){
            context.buildAndSwitch();
            serverWorld.tick(hasTimeLeft);
        }
    }

    @Inject(method={"wrapRunnable(Ljava/lang/Runnable;)Lnet/minecraft/server/TickTask;"}, at={@At(value="RETURN")})
    private void tracker$associatePhaseContextWithWrappedTask(Runnable runnable, CallbackInfoReturnable<TickTask> cir) {
        TickTask returnValue = (TickTask)cir.getReturnValue();
        if (!PhaseTracker.SERVER.onSidedThread()) {
            PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (phaseContext.isEmpty()) {
                return;
            }
            phaseContext.foldContextForThread((TickTaskBridge)returnValue);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"doRunTask(Lnet/minecraft/server/TickTask;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/thread/ReentrantBlockableEventLoop;doRunTask(Ljava/lang/Runnable;)V"))
    private void tracker$wrapAndPerformContextSwitch(ReentrantBlockableEventLoop<?> thisServer, Runnable runnable) {
        try (@NonNull DelayedTaskPhaseState.Context context = ((DelayedTaskPhaseState.Context)PluginPhase.State.DELAYED_TASK.createPhaseContext(PhaseTracker.SERVER).source(runnable)).setDelayedContextPopulator(((TickTaskBridge)((Object)runnable)).bridge$getFrameModifier().orElse(null));){
            context.buildAndSwitch();
            super.shadow$doRunTask(runnable);
        }
    }

    @Override
    protected boolean tracker$isServerAndIsServerStopped() {
        return this.shadow$isStopped();
    }
}

