/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.thread.BlockableEventLoop;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;

public final class PacketSender {
    public static void sendTo(EngineConnection connection, Packet<?> packet) {
        PacketSender.sendTo(connection, packet, (Consumer<Future<? super Void>>)null);
    }

    public static void sendTo(EngineConnection connection, Packet<?> packet, @Nullable Consumer<Future<? super Void>> listener) {
        Connection networkManager = ((ConnectionHolderBridge)((Object)connection)).bridge$getConnection();
        networkManager.send(packet, (PacketSendListener)(listener == null ? null : new SpongePacketSendListener(connection.side(), listener)));
    }

    public static void sendTo(EngineConnection connection, Packet<?> packet, CompletableFuture<Void> future) {
        PacketSender.sendTo(connection, packet, (Future<? super Void> sendFuture) -> {
            if (sendFuture.isSuccess()) {
                future.complete(null);
            } else {
                future.completeExceptionally(sendFuture.cause());
            }
        });
    }

    private PacketSender() {
    }

    public static final class SpongePacketSendListener
    implements PacketSendListener {
        private final BlockableEventLoop<?> executor;
        private final Consumer<Future<? super Void>> listener;

        public SpongePacketSendListener(EngineConnectionSide<? extends EngineConnection> side, Consumer<Future<? super Void>> listener) {
            this.executor = (BlockableEventLoop)(side == EngineConnectionSide.CLIENT ? Sponge.client() : Sponge.server());
            this.listener = listener;
        }

        public void accept(Future nettyFuture) {
            this.executor.execute(() -> this.listener.accept((Future<? super Void>)nettyFuture));
        }
    }
}

