/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketHandler;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.api.network.channel.packet.ResponsePacketHandler;
import org.spongepowered.api.network.channel.packet.TransactionalPacketBinding;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.packet.PacketToResponseHandler;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;

public class SpongeTransactionalPacketBinding<P extends RequestPacket<R>, R extends Packet>
extends SpongePacketBinding<P>
implements TransactionalPacketBinding<P, R> {
    private final Map<Class<?>, RequestPacketHandler<? super P, ? extends R, ?>> requestHandlers = new HashMap();
    private final ConcurrentMultimap<Class<?>, ResponsePacketHandler<? super P, ? super R, ?>> responseHandlers = new ConcurrentMultimap();

    public SpongeTransactionalPacketBinding(int opcode, Class<P> requestPacketType) {
        super(opcode, requestPacketType);
    }

    public <C extends EngineConnection> @Nullable RequestPacketHandler<? super P, ? extends R, C> getRequestHandler(C connection) {
        return SpongeChannel.getRequestHandler(connection, this.requestHandlers);
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> setRequestHandler(EngineConnectionSide<C> side, RequestPacketHandler<? super P, ? extends R, ? super C> handler) {
        Objects.requireNonNull(side, "side");
        return this.setRequestHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> setRequestHandler(Class<C> connectionType, RequestPacketHandler<? super P, ? extends R, ? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.requestHandlers.put(connectionType, handler);
        return this;
    }

    @Override
    public TransactionalPacketBinding<P, R> setRequestHandler(RequestPacketHandler<? super P, ? extends R, EngineConnection> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.setRequestHandler(EngineConnection.class, handler);
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> addResponseHandler(EngineConnectionSide<C> side, PacketHandler<? super R, ? super C> handler) {
        Objects.requireNonNull(side, "side");
        return this.addResponseHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> addResponseHandler(Class<C> connectionType, PacketHandler<? super R, ? super C> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.addResponseHandler(connectionType, new PacketToResponseHandler(handler));
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> addResponseHandler(EngineConnectionSide<C> side, ResponsePacketHandler<? super P, ? super R, ? super C> handler) {
        Objects.requireNonNull(side, "side");
        Objects.requireNonNull(handler, "handler");
        return this.addResponseHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> TransactionalPacketBinding<P, R> addResponseHandler(Class<C> connectionType, ResponsePacketHandler<? super P, ? super R, ? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.responseHandlers.modify(map -> map.put((Object)connectionType, (Object)handler));
        return this;
    }

    @Override
    public TransactionalPacketBinding<P, R> addResponseHandler(PacketHandler<? super R, EngineConnection> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.addResponseHandler(new PacketToResponseHandler(handler));
    }

    @Override
    public TransactionalPacketBinding<P, R> addResponseHandler(ResponsePacketHandler<? super P, ? super R, EngineConnection> handler) {
        return this.addResponseHandler(EngineConnection.class, handler);
    }

    public <C extends EngineConnection> Collection<ResponsePacketHandler<? super P, ? super R, ? super C>> getResponseHandlers(C connection) {
        return SpongeChannel.getResponseHandlers(connection, this.responseHandlers.get());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("opcode", this.opcode()).add("requestPacketType", this.packetType()).toString();
    }
}

