/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.raw;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;

public class SpongeRawPlayDataChannel
implements RawPlayDataChannel {
    private final ConcurrentMultimap<Class<?>, RawPlayDataHandler<?>> handlers = new ConcurrentMultimap();
    private final SpongeRawDataChannel parent;

    public SpongeRawPlayDataChannel(SpongeRawDataChannel parent) {
        this.parent = parent;
    }

    @Override
    public SpongeRawDataChannel parent() {
        return this.parent;
    }

    @Override
    public boolean isSupportedBy(EngineConnection connection) {
        Objects.requireNonNull(connection, "connection");
        return ConnectionUtil.getRegisteredChannels(connection).contains(this.parent.key());
    }

    @Override
    public void addHandler(RawPlayDataHandler<EngineConnection> handler) {
        this.addHandler(EngineConnection.class, handler);
    }

    @Override
    public <C extends EngineConnection> void addHandler(EngineConnectionSide<C> side, RawPlayDataHandler<? super C> handler) {
        Objects.requireNonNull(side, "side");
        Objects.requireNonNull(handler, "handler");
        this.addHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> void addHandler(Class<C> connectionType, RawPlayDataHandler<? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.put((Object)connectionType, (Object)handler));
    }

    @Override
    public void removeHandler(RawPlayDataHandler<?> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> entry.getValue() == handler));
    }

    @Override
    public <C extends EngineConnection> void removeHandler(EngineConnectionSide<C> side, RawPlayDataHandler<? super C> handler) {
        Objects.requireNonNull(side, "side");
        this.removeHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> void removeHandler(Class<C> connectionType, RawPlayDataHandler<? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> ((Class)entry.getKey()).isAssignableFrom(connectionType) && entry.getValue() == handler));
    }

    @Override
    public CompletableFuture<Void> sendTo(EngineConnection connection, Consumer<ChannelBuf> consumer) {
        ChannelBuf payload;
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(consumer, "payload");
        ConnectionUtil.checkPlayPhase(connection);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            payload = this.parent.encodePayload(consumer);
        }
        catch (Throwable ex) {
            this.parent.handleException(connection, ex, future);
            return future;
        }
        Packet<?> mcPacket = PacketUtil.createPlayPayload(this.parent.key(), payload, connection.side());
        PacketSender.sendTo(connection, mcPacket, future);
        return future;
    }

    private <C extends EngineConnection> Collection<RawPlayDataHandler<? super C>> getHandlers(C connection) {
        return SpongeChannel.getResponseHandlers(connection, this.handlers.get());
    }

    <C extends EngineConnection> void handlePayload(C connection, ChannelBuf payload) {
        for (RawPlayDataHandler<C> handler : this.getHandlers(connection)) {
            handler.handlePayload(payload.slice(), connection);
        }
    }
}

