/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.FrameType;
import net.minecraft.core.FrontAndTop;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraft.world.ticks.TickPriority;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.criteria.Criteria;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.common.accessor.advancements.CriteriaTriggersAccessor;
import org.spongepowered.common.accessor.world.entity.animal.MushroomCow_MushroomTypeAccessor;
import org.spongepowered.common.accessor.world.entity.boss.enderdragon.phases.EnderDragonPhaseAccessor;
import org.spongepowered.common.accessor.world.item.ArmorMaterialsAccessor;
import org.spongepowered.common.accessor.world.level.GameRulesAccessor;
import org.spongepowered.common.advancement.criterion.SpongeDummyTrigger;
import org.spongepowered.common.advancement.criterion.SpongeScoreTrigger;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.SpongeRegistryHolder;

final class VanillaRegistryLoader {
    private final SpongeRegistryHolder holder;

    public static void load(SpongeRegistryHolder holder) {
        VanillaRegistryLoader loader = new VanillaRegistryLoader(holder);
        loader.loadEnumRegistries();
        loader.loadInstanceRegistries();
    }

    private VanillaRegistryLoader(SpongeRegistryHolder holder) {
        this.holder = holder;
    }

    private void loadInstanceRegistries() {
        this.holder.createRegistry(RegistryTypes.CRITERION, VanillaRegistryLoader.criterion());
        this.manualOrAutomaticName(RegistryTypes.DRAGON_PHASE_TYPE, EnderDragonPhaseAccessor.accessor$PHASES(), map -> {
            map.put(EnderDragonPhase.HOLDING_PATTERN, "holding_pattern");
            map.put(EnderDragonPhase.STRAFE_PLAYER, "strafe_player");
            map.put(EnderDragonPhase.LANDING_APPROACH, "landing_approach");
            map.put(EnderDragonPhase.LANDING, "landing");
            map.put(EnderDragonPhase.TAKEOFF, "takeoff");
            map.put(EnderDragonPhase.SITTING_FLAMING, "sitting_flaming");
            map.put(EnderDragonPhase.SITTING_SCANNING, "sitting_scanning");
            map.put(EnderDragonPhase.SITTING_ATTACKING, "sitting_attacking");
            map.put(EnderDragonPhase.CHARGING_PLAYER, "charging_player");
            map.put(EnderDragonPhase.DYING, "dying");
            map.put(EnderDragonPhase.HOVERING, "hover");
        }, phase -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ((EnderDragonPhaseAccessor)phase).accessor$name()));
        this.holder.createRegistry(RegistryTypes.FIREWORK_SHAPE, VanillaRegistryLoader.fireworkShape());
        this.holder.createRegistry(RegistryTypes.TRIGGER, VanillaRegistryLoader.trigger(), true, (k, trigger) -> CriteriaTriggersAccessor.invoker$register((CriterionTrigger)trigger));
        this.knownName(RegistryTypes.GAME_RULE, GameRulesAccessor.accessor$GAME_RULE_TYPES().keySet(), (I rule) -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, rule.getId()));
    }

    private void loadEnumRegistries() {
        this.knownName(RegistryTypes.ARMOR_MATERIAL, (Enum[])ArmorMaterials.values(), am -> ((ArmorMaterialsAccessor)am).accessor$name());
        this.automaticSerializedName(RegistryTypes.ATTACHMENT_SURFACE, (Enum[])AttachFace.values());
        this.automaticSerializedName(RegistryTypes.BAMBOO_LEAVES_TYPE, (Enum[])BambooLeaves.values());
        this.automaticSerializedName(RegistryTypes.BELL_ATTACHMENT_TYPE, (Enum[])BellAttachType.values());
        this.manualName(RegistryTypes.ATTRIBUTE_OPERATION, (Enum[])AttributeModifier.Operation.values(), map -> {
            map.put(AttributeModifier.Operation.ADDITION, "addition");
            map.put(AttributeModifier.Operation.MULTIPLY_BASE, "multiply_base");
            map.put(AttributeModifier.Operation.MULTIPLY_TOTAL, "multiply_total");
        });
        this.knownName(RegistryTypes.BOAT_TYPE, (Enum[])Boat.Type.values(), Boat.Type::getName);
        this.automaticSerializedName(RegistryTypes.CHEST_ATTACHMENT_TYPE, (Enum[])ChestType.values());
        this.manualName(RegistryTypes.COLLISION_RULE, (Enum[])Team.CollisionRule.values(), map -> {
            map.put(Team.CollisionRule.ALWAYS, "always");
            map.put(Team.CollisionRule.NEVER, "never");
            map.put(Team.CollisionRule.PUSH_OTHER_TEAMS, "push_other_teams");
            map.put(Team.CollisionRule.PUSH_OWN_TEAM, "push_own_team");
        });
        this.automaticSerializedName(RegistryTypes.COMPARATOR_MODE, (Enum[])ComparatorMode.values());
        this.knownName(RegistryTypes.DIFFICULTY, (Enum[])Difficulty.values(), Difficulty::getKey);
        this.automaticSerializedName(RegistryTypes.DYE_COLOR, (Enum[])DyeColor.values());
        this.automaticSerializedName(RegistryTypes.DOOR_HINGE, (Enum[])DoorHingeSide.values());
        this.automaticSerializedName(RegistryTypes.DRIPSTONE_SEGMENT, (Enum[])DripstoneThickness.values());
        this.manualName(RegistryTypes.EQUIPMENT_GROUP, (Enum[])EquipmentSlot.Type.values(), map -> {
            map.put(EquipmentSlot.Type.ARMOR, "worn");
            map.put(EquipmentSlot.Type.HAND, "held");
        });
        this.manualName(RegistryTypes.EQUIPMENT_TYPE, (Enum[])EquipmentSlot.values(), map -> {
            map.put(EquipmentSlot.CHEST, "chest");
            map.put(EquipmentSlot.FEET, "feet");
            map.put(EquipmentSlot.HEAD, "head");
            map.put(EquipmentSlot.LEGS, "legs");
            map.put(EquipmentSlot.MAINHAND, "main_hand");
            map.put(EquipmentSlot.OFFHAND, "off_hand");
        });
        this.knownName(RegistryTypes.FOX_TYPE, (Enum[])Fox.Type.values(), Fox.Type::getName);
        this.manualName(RegistryTypes.GAME_MODE, (Enum[])GameType.values(), map -> {
            map.put(GameType.SURVIVAL, GameType.SURVIVAL.getName());
            map.put(GameType.CREATIVE, GameType.CREATIVE.getName());
            map.put(GameType.ADVENTURE, GameType.ADVENTURE.getName());
            map.put(GameType.SPECTATOR, GameType.SPECTATOR.getName());
        });
        this.automaticName(RegistryTypes.HAND_PREFERENCE, (Enum[])HumanoidArm.values());
        this.automaticName(RegistryTypes.HAND_TYPE, (Enum[])InteractionHand.values());
        this.automaticSerializedName(RegistryTypes.INSTRUMENT_TYPE, (Enum[])NoteBlockInstrument.values());
        this.automaticName(RegistryTypes.ITEM_RARITY, (Enum[])Rarity.values());
        this.automaticName(RegistryTypes.ITEM_TIER, (Enum[])Tiers.values());
        this.automaticSerializedName(RegistryTypes.JIGSAW_BLOCK_ORIENTATION, (Enum[])FrontAndTop.values());
        this.knownName(RegistryTypes.MOOSHROOM_TYPE, (Enum[])MushroomCow.MushroomType.values(), type -> ((MushroomCow_MushroomTypeAccessor)type).accessor$type());
        this.knownName(RegistryTypes.OBJECTIVE_DISPLAY_MODE, (Enum[])ObjectiveCriteria.RenderType.values(), ObjectiveCriteria.RenderType::getId);
        this.knownName(RegistryTypes.PANDA_GENE, (Enum[])Panda.Gene.values(), Panda.Gene::getName);
        this.automaticName(RegistryTypes.PHANTOM_PHASE, (Enum[])Phantom.AttackPhase.values());
        this.automaticName(RegistryTypes.PICKUP_RULE, (Enum[])AbstractArrow.Pickup.values());
        this.automaticName(RegistryTypes.MIRROR, (Enum[])Mirror.values());
        this.automaticName(RegistryTypes.CHAT_VISIBILITY, (Enum[])ChatVisiblity.values());
        this.automaticSerializedName(RegistryTypes.PISTON_TYPE, (Enum[])PistonType.values());
        this.automaticSerializedName(RegistryTypes.PORTION_TYPE, (Enum[])Half.values());
        this.automaticName(RegistryTypes.RAID_STATUS, (Enum[])Raid.RaidStatus.values());
        this.automaticName(RegistryTypes.ROTATION, (Enum[])Rotation.values());
        this.automaticSerializedName(RegistryTypes.RAIL_DIRECTION, (Enum[])RailShape.values());
        this.automaticSerializedName(RegistryTypes.SCULK_SENSOR_STATE, (Enum[])SculkSensorPhase.values());
        this.automaticSerializedName(RegistryTypes.SLAB_PORTION, (Enum[])SlabType.values());
        this.automaticName(RegistryTypes.SPELL_TYPE, (Enum[])SpellcasterIllager.IllagerSpell.values());
        this.automaticSerializedName(RegistryTypes.STAIR_SHAPE, (Enum[])StairsShape.values());
        this.automaticSerializedName(RegistryTypes.STRUCTURE_MODE, (Enum[])StructureMode.values());
        this.automaticSerializedName(RegistryTypes.TILT, (Enum[])Tilt.values());
        this.automaticName(RegistryTypes.TASK_PRIORITY, (Enum[])TickPriority.values());
        this.manualName(RegistryTypes.VISIBILITY, (Enum[])Team.Visibility.values(), map -> {
            map.put(Team.Visibility.ALWAYS, "always");
            map.put(Team.Visibility.NEVER, "never");
            map.put(Team.Visibility.HIDE_FOR_OTHER_TEAMS, "hide_for_other_teams");
            map.put(Team.Visibility.HIDE_FOR_OWN_TEAM, "hide_for_own_team");
        });
        this.automaticSerializedName(RegistryTypes.WIRE_ATTACHMENT_TYPE, (Enum[])RedstoneSide.values());
        this.knownName(RegistryTypes.ADVANCEMENT_TYPE, (Enum[])FrameType.values(), FrameType::getName);
        this.automaticName(RegistryTypes.TROPICAL_FISH_SHAPE, (Enum[])TropicalFish.Pattern.values());
        this.automaticName(RegistryTypes.HEIGHT_TYPE, (Enum[])Heightmap.Types.values());
        this.knownName(RegistryTypes.ENTITY_CATEGORY, (Enum[])MobCategory.values(), VanillaRegistryLoader.sanitizedName(MobCategory::getName));
        this.automaticSerializedName(RegistryTypes.WALL_TYPE, (Enum[])WallSide.values());
        this.automaticName(RegistryTypes.GRASS_COLOR_MODIFIER, (Enum[])BiomeSpecialEffects.GrassColorModifier.values());
        this.automaticName(RegistryTypes.PRECIPITATION, (Enum[])Biome.Precipitation.values());
        this.automaticName(RegistryTypes.TEMPERATURE_MODIFIER, (Enum[])Biome.TemperatureModifier.values());
        this.automaticName(RegistryTypes.CARVING_STEP, (Enum[])GenerationStep.Carving.values());
        this.automaticName(RegistryTypes.DECORATION_STEP, (Enum[])GenerationStep.Decoration.values());
    }

    private static RegistryLoader<Criterion> criterion() {
        return RegistryLoader.of(l -> {
            l.add(Criteria.AIR, k -> (Criterion)ObjectiveCriteria.AIR);
            l.add(Criteria.ARMOR, k -> (Criterion)ObjectiveCriteria.ARMOR);
            l.add(Criteria.DEATH_COUNT, k -> (Criterion)ObjectiveCriteria.DEATH_COUNT);
            l.add(Criteria.DUMMY, k -> (Criterion)ObjectiveCriteria.DUMMY);
            l.add(Criteria.EXPERIENCE, k -> (Criterion)ObjectiveCriteria.EXPERIENCE);
            l.add(Criteria.FOOD, k -> (Criterion)ObjectiveCriteria.FOOD);
            l.add(Criteria.HEALTH, k -> (Criterion)ObjectiveCriteria.HEALTH);
            l.add(Criteria.LEVEL, k -> (Criterion)ObjectiveCriteria.LEVEL);
            l.add(Criteria.PLAYER_KILL_COUNT, k -> (Criterion)ObjectiveCriteria.KILL_COUNT_PLAYERS);
            l.add(Criteria.TOTAL_KILL_COUNT, k -> (Criterion)ObjectiveCriteria.KILL_COUNT_ALL);
            l.add(Criteria.TRIGGER, k -> (Criterion)ObjectiveCriteria.TRIGGER);
        });
    }

    private static RegistryLoader<FireworkShape> fireworkShape() {
        return RegistryLoader.of(l -> {
            l.add(FireworkRocketItem.Shape.BURST.getId(), FireworkShapes.BURST, () -> (FireworkShape)FireworkRocketItem.Shape.BURST);
            l.add(FireworkRocketItem.Shape.CREEPER.getId(), FireworkShapes.CREEPER, () -> (FireworkShape)FireworkRocketItem.Shape.CREEPER);
            l.add(FireworkRocketItem.Shape.LARGE_BALL.getId(), FireworkShapes.LARGE_BALL, () -> (FireworkShape)FireworkRocketItem.Shape.LARGE_BALL);
            l.add(FireworkRocketItem.Shape.SMALL_BALL.getId(), FireworkShapes.SMALL_BALL, () -> (FireworkShape)FireworkRocketItem.Shape.SMALL_BALL);
            l.add(FireworkRocketItem.Shape.STAR.getId(), FireworkShapes.STAR, () -> (FireworkShape)FireworkRocketItem.Shape.STAR);
        });
    }

    private static RegistryLoader<Trigger<?>> trigger() {
        SpongeDummyTrigger loadMe1 = SpongeDummyTrigger.DUMMY_TRIGGER;
        SpongeScoreTrigger loadMe2 = SpongeScoreTrigger.SCORE_TRIGGER;
        return RegistryLoader.of(l -> CriteriaTriggers.all().forEach(trigger -> l.add((ResourceKey)trigger.getId(), (Trigger)trigger)));
    }

    private <A, I extends Enum<I>> Registry<A> automaticName(RegistryType<A> type, I[] values) {
        return this.naming(type, (Enum[])values, VanillaRegistryLoader.sanitizedName(Enum::name));
    }

    private <A, I extends Enum<I>> Registry<A> automaticSerializedName(RegistryType<A> type, I[] values) {
        return this.naming(type, (Enum[])values, val -> ((StringRepresentable)val).getSerializedName());
    }

    private <A, I extends Enum<I>> Registry<A> knownName(RegistryType<A> type, I[] values, Function<I, String> name) {
        return this.naming(type, (Enum[])values, name);
    }

    private <A, I> Registry<A> knownName(RegistryType<A> type, Collection<I> values, Function<I, String> name) {
        HashMap<I, String> map = new HashMap<I, String>();
        for (I value : values) {
            map.put(value, name.apply(value));
        }
        return this.naming(type, values.size(), map);
    }

    private <A, I extends Enum<I>> Registry<A> manualName(RegistryType<A> type, I[] values, Consumer<Manual<A, I>> byName) {
        HashMap map = new HashMap(values.length);
        byName.accept(map::put);
        return this.naming(type, values, map);
    }

    private <A, I> Registry<A> manualOrAutomaticName(RegistryType<A> type, I[] values, Consumer<Manual<A, I>> byName, Function<I, String> autoName) {
        HashMap<I, String> map = new HashMap<I, String>(values.length);
        byName.accept(map::put);
        for (I value : values) {
            map.computeIfAbsent(value, autoName);
        }
        return this.naming(type, values, map);
    }

    private <A, I extends Enum<I>> Registry<A> naming(RegistryType<A> type, I[] values, Function<I, String> name) {
        HashMap<I, String> map = new HashMap<I, String>();
        for (I value : values) {
            map.put(value, name.apply(value));
        }
        return this.naming(type, values, map);
    }

    private <A, I> Registry<A> naming(RegistryType<A> type, I[] values, Map<I, String> byName) {
        return this.naming(type, values.length, byName);
    }

    private <A, I> Registry<A> naming(RegistryType<A> type, int values, Map<I, String> byName) {
        if (values != byName.size()) {
            throw new IllegalStateException(type.location() + " in " + type.root() + " is has value mismatch: " + values + " / " + byName.size());
        }
        return this.holder.createRegistry(type, () -> {
            HashMap map = new HashMap();
            for (Map.Entry value : byName.entrySet()) {
                String rawId = (String)value.getValue();
                if (rawId.contains(":")) {
                    map.put((ResourceKey)new ResourceLocation(rawId), value.getKey());
                    continue;
                }
                map.put(ResourceKey.sponge(rawId), value.getKey());
            }
            return map;
        }, false);
    }

    private static <I> Function<I, String> sanitizedName(Function<I, String> original) {
        return original.andThen(s -> s.toLowerCase(Locale.ROOT));
    }

    private static interface Manual<A, I> {
        public void put(I var1, String var2);
    }
}

