/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.service.server.permission.GlobalMemorySubjectData;
import org.spongepowered.common.service.server.permission.OpLevelCollection;

public class SingleParentMemorySubjectData
extends GlobalMemorySubjectData {
    private SubjectReference parent;

    public SingleParentMemorySubjectData(Subject subject) {
        super(subject);
    }

    @Override
    public List<SubjectReference> parents(Set<Context> contexts) {
        SubjectReference parent = this.parent();
        return contexts.isEmpty() && parent != null ? Collections.singletonList(parent) : Collections.emptyList();
    }

    @Override
    public CompletableFuture<Boolean> addParent(Set<Context> contexts, SubjectReference parent) {
        if (!(parent instanceof OpLevelCollection.OpLevelSubject)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!contexts.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        this.setParent(parent);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(Set<Context> contexts, SubjectReference parent) {
        if (parent == this.parent) {
            this.setParent(null);
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        return this.removeParent(SubjectData.GLOBAL_CONTEXT, this.parent);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(Set<Context> contexts) {
        if (!contexts.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.clearParents();
    }

    public void setParent(@Nullable SubjectReference parent) {
        this.parent = parent;
    }

    public @Nullable SubjectReference parent() {
        return this.parent;
    }
}

