/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.tag;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.tag.TagTemplate;
import org.spongepowered.api.tag.Taggable;
import org.spongepowered.common.SpongeCommon;

public final class SpongeTagTemplate<T extends Taggable<T>>
extends Record
implements TagTemplate<T> {
    private final ResourceKey key;
    private final boolean replace;
    private final Map<ResourceKey, Boolean> elements;
    private final Map<ResourceKey, Boolean> subTags;
    private final DataPack<TagTemplate<T>> pack;

    public SpongeTagTemplate(ResourceKey key, boolean replace, Map<ResourceKey, Boolean> elements, Map<ResourceKey, Boolean> subTags, DataPack<TagTemplate<T>> pack) {
        this.key = key;
        this.replace = replace;
        this.elements = elements;
        this.subTags = subTags;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        JsonObject jsonObject = SpongeTagTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            DataContainer container = DataFormats.JSON.get().read(jsonObject.getAsString());
            container.set(DataQuery.of("replace"), this.replace);
            return container;
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Error reading json serialized by minecraft", (Throwable)e);
            return DataContainer.createNew();
        }
    }

    public static <T extends Taggable<T>> JsonObject encode(TagTemplate<T> template, RegistryAccess registryAccess) {
        TagBuilder builder = TagBuilder.create();
        SpongeTagTemplate spongeTemplate = (SpongeTagTemplate)template;
        spongeTemplate.elements.forEach((k, v) -> {
            ResourceLocation location = (ResourceLocation)k;
            if (v.booleanValue()) {
                builder.addElement(location);
            } else {
                builder.addOptionalElement(location);
            }
        });
        spongeTemplate.subTags.forEach((k, v) -> {
            ResourceLocation location = (ResourceLocation)k;
            if (v.booleanValue()) {
                builder.addTag(location);
            } else {
                builder.addOptionalTag(location);
            }
        });
        return ((JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(builder.build(), spongeTemplate.replace)).getOrThrow(false, e -> {})).getAsJsonObject();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public boolean replace() {
        return this.replace;
    }

    public Map<ResourceKey, Boolean> elements() {
        return this.elements;
    }

    public Map<ResourceKey, Boolean> subTags() {
        return this.subTags;
    }

    @Override
    public DataPack<TagTemplate<T>> pack() {
        return this.pack;
    }
}

