/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.metric;

import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.config.metrics.MetricsConfig;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeMetricsConfigManager
implements MetricsConfigManager {
    private final ConfigHandle<MetricsConfig> metrics = SpongeConfigs.create(MetricsConfig.class, MetricsConfig::transformation, "metrics.conf");

    public CompletableFuture<CommentedConfigurationNode> savePluginsInConfig(Map<String, Tristate> entries) {
        return this.metrics.updateSetting("plugin-states", entries, new TypeToken<Map<String, Tristate>>(){});
    }

    @Override
    public Tristate globalCollectionState() {
        return this.metrics.get().globalState;
    }

    @Override
    public Tristate collectionState(PluginContainer container) {
        return this.metrics.get().getCollectionState(container);
    }
}

