/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.FixedBiomeProvider;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.accessor.world.level.biome.TheEndBiomeSourceAccessor;

public final class SpongeBiomeProviderFactory
implements BiomeProvider.Factory {
    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld() {
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource(this.registry());
    }

    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> multiNoise(MultiNoiseBiomeConfig config) {
        ArrayList<Pair> climateParams = new ArrayList<Pair>();
        for (AttributedBiome attributedBiome : config.attributedBiomes()) {
            climateParams.add(Pair.of((Object)((Climate.ParameterPoint)attributedBiome.attributes()), this.biomeHolder(attributedBiome.biome())));
        }
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSourceAccessor.invoker$new((Climate.ParameterList<Holder<Biome>>)new Climate.ParameterList(climateParams));
    }

    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSource.Preset.NETHER.biomeSource(this.registry());
    }

    @Override
    public ConfigurableBiomeProvider<EndStyleBiomeConfig> endStyle(EndStyleBiomeConfig config) {
        return (ConfigurableBiomeProvider)TheEndBiomeSourceAccessor.invoker$new(this.biomeHolder(config.endBiome()), this.biomeHolder(config.highlandsBiome()), this.biomeHolder(config.midlandsBiome()), this.biomeHolder(config.islandsBiome()), this.biomeHolder(config.barrensBiome()));
    }

    @Override
    public ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return (ConfigurableBiomeProvider)new TheEndBiomeSource(this.registry());
    }

    @Override
    public ConfigurableBiomeProvider<CheckerboardBiomeConfig> checkerboard(CheckerboardBiomeConfig config) {
        List biomes = config.biomes().stream().map(this::biomeHolder).collect(Collectors.toList());
        return (ConfigurableBiomeProvider)new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(biomes), config.scale());
    }

    @Override
    public FixedBiomeProvider fixed(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        Objects.requireNonNull(biome, "biome");
        return (FixedBiomeProvider)new FixedBiomeSource(this.biomeHolder(biome));
    }

    private Registry<Biome> registry() {
        return SpongeCommon.server().registryAccess().registryOrThrow(Registry.BIOME_REGISTRY);
    }

    private Holder<Biome> biomeHolder(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        return this.registry().getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)biome.location())));
    }
}

