/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.EntityCategory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeTemplate;
import org.spongepowered.api.world.biome.ambient.ParticleConfig;
import org.spongepowered.api.world.biome.ambient.SoundConfig;
import org.spongepowered.api.world.biome.climate.GrassColorModifier;
import org.spongepowered.api.world.biome.climate.GrassColorModifiers;
import org.spongepowered.api.world.biome.climate.Precipitation;
import org.spongepowered.api.world.biome.climate.TemperatureModifier;
import org.spongepowered.api.world.biome.climate.TemperatureModifiers;
import org.spongepowered.api.world.biome.spawner.NaturalSpawnCost;
import org.spongepowered.api.world.generation.carver.CarvingStep;
import org.spongepowered.api.world.generation.feature.DecorationStep;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeBiomeTemplate
extends Record
implements BiomeTemplate {
    private final ResourceKey key;
    private final net.minecraft.world.level.biome.Biome representedBiome;
    private final DataPack<BiomeTemplate> pack;

    public SpongeBiomeTemplate(ResourceKey key, net.minecraft.world.level.biome.Biome representedBiome, DataPack<BiomeTemplate> pack) {
        this.key = key;
        this.representedBiome = representedBiome;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeBiomeTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Biome:\n" + serialized, e);
        }
    }

    @Override
    public Biome biome() {
        return (Biome)this.representedBiome;
    }

    public static JsonElement encode(BiomeTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (JsonElement)net.minecraft.world.level.biome.Biome.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((net.minecraft.world.level.biome.Biome)template.biome())).getOrThrow(false, e -> {});
    }

    public static net.minecraft.world.level.biome.Biome decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (net.minecraft.world.level.biome.Biome)net.minecraft.world.level.biome.Biome.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static BiomeTemplate decode(DataPack<BiomeTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        net.minecraft.world.level.biome.Biome parsed = SpongeBiomeTemplate.decode(packEntry, registryAccess);
        return new SpongeBiomeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public net.minecraft.world.level.biome.Biome representedBiome() {
        return this.representedBiome;
    }

    @Override
    public DataPack<BiomeTemplate> pack() {
        return this.pack;
    }

    public static class BuilderImpl
    extends AbstractDataPackEntryBuilder<Biome, BiomeTemplate, BiomeTemplate.Builder>
    implements BiomeTemplate.Builder {
        private static DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(net.minecraft.world.level.biome.Biome.class);
        private DataManipulator.Mutable manipulator = DataManipulator.mutableOf();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<BiomeTemplate, Biome> valueExtractor() {
            return BiomeTemplate::biome;
        }

        @Override
        public <V> BiomeTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported((Type)((Object)net.minecraft.world.level.biome.Biome.class))) {
                throw new IllegalArgumentException(key + " is not supported for biomes");
            }
            this.manipulator.set(key, value);
            return this;
        }

        @Override
        public BiomeTemplate.Builder reset() {
            this.manipulator = DataManipulator.mutableOf();
            this.key = null;
            this.pack = DataPacks.BIOME;
            return this;
        }

        @Override
        public BiomeTemplate.Builder fromValue(Biome biome) {
            this.manipulator.set(biome.getValues());
            return this;
        }

        @Override
        public BiomeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            net.minecraft.world.level.biome.Biome biome = SpongeBiomeTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((Biome)biome);
            return this;
        }

        @Override
        protected BiomeTemplate build0() {
            Precipitation precipitation = this.manipulator.require(Keys.PRECIPITATION);
            Double temperature = this.manipulator.require(Keys.BIOME_TEMPERATURE);
            Double downfall = this.manipulator.require(Keys.HUMIDITY);
            TemperatureModifier temperatureModifier = this.manipulator.getOrElse(Keys.TEMPERATURE_MODIFIER, TemperatureModifiers.NONE.get());
            Color fogColor = this.manipulator.require(Keys.FOG_COLOR);
            Color waterColor = this.manipulator.require(Keys.WATER_COLOR);
            Color waterFogColor = this.manipulator.require(Keys.WATER_FOG_COLOR);
            Color skyColor = this.manipulator.require(Keys.SKY_COLOR);
            Optional<Color> foliageColor = this.manipulator.get(Keys.FOLIAGE_COLOR);
            Optional<Color> grassColor = this.manipulator.get(Keys.GRASS_COLOR);
            GrassColorModifier grassColorModifier = this.manipulator.getOrElse(Keys.GRASS_COLOR_MODIFIER, GrassColorModifiers.NONE.get());
            Optional<ParticleConfig> particleSettings = this.manipulator.get(Keys.AMBIENT_PARTICLE);
            Optional<SoundType> ambientSound = this.manipulator.get(Keys.AMBIENT_SOUND);
            Optional<SoundConfig.Mood> ambientMood = this.manipulator.get(Keys.AMBIENT_MOOD);
            Optional<SoundConfig.Additional> additionalSound = this.manipulator.get(Keys.AMBIENT_ADDITIONAL_SOUND);
            Optional<SoundConfig.BackgroundMusic> backgroundMusic = this.manipulator.get(Keys.BACKGROUND_MUSIC);
            Double spawnChance = this.manipulator.require(Keys.SPAWN_CHANCE);
            Map<EntityCategory, List> spawners = this.manipulator.getOrElse(Keys.NATURAL_SPAWNERS, Map.of());
            Map<EntityType, NaturalSpawnCost> spawnerCosts = this.manipulator.getOrElse(Keys.NATURAL_SPAWNER_COST, Map.of());
            Map<DecorationStep, List> features = this.manipulator.getOrElse(Keys.FEATURES, Map.of());
            Map<CarvingStep, List> carvers = this.manipulator.getOrElse(Keys.CARVERS, Map.of());
            BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder().fogColor(fogColor.rgb()).waterColor(waterColor.rgb()).waterFogColor(waterFogColor.rgb()).skyColor(skyColor.rgb()).grassColorModifier((BiomeSpecialEffects.GrassColorModifier)grassColorModifier);
            foliageColor.ifPresent(c -> effectsBuilder.foliageColorOverride(c.rgb()));
            grassColor.ifPresent(c -> effectsBuilder.grassColorOverride(c.rgb()));
            particleSettings.ifPresent(ps -> effectsBuilder.ambientParticle((AmbientParticleSettings)ps));
            ambientSound.ifPresent(s -> effectsBuilder.ambientLoopSound((SoundEvent)s));
            ambientMood.ifPresent(m -> effectsBuilder.ambientMoodSound((AmbientMoodSettings)m));
            additionalSound.ifPresent(s -> effectsBuilder.ambientAdditionsSound((AmbientAdditionsSettings)s));
            backgroundMusic.ifPresent(m -> effectsBuilder.backgroundMusic((Music)m));
            MobSpawnSettings.Builder spawnerBuilder = new MobSpawnSettings.Builder().creatureGenerationProbability(spawnChance.floatValue());
            spawners.forEach((cat, spawner) -> spawner.forEach(sp -> spawnerBuilder.addSpawn((MobCategory)cat, (MobSpawnSettings.SpawnerData)sp)));
            spawnerCosts.forEach((type, cost) -> spawnerBuilder.addMobCharge((net.minecraft.world.entity.EntityType)type, cost.budget(), cost.charge()));
            BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder();
            features.forEach((step, list) -> list.forEach(feature -> generationBuilder.addFeature((GenerationStep.Decoration)step, Holder.direct((Object)((PlacedFeature)feature)))));
            carvers.forEach((step, list) -> list.forEach(carver -> generationBuilder.addCarver((GenerationStep.Carving)step, Holder.direct((Object)((ConfiguredWorldCarver)carver)))));
            Biome.BiomeBuilder vanillaBuilder = new Biome.BiomeBuilder().precipitation((Biome.Precipitation)precipitation).temperature(temperature.floatValue()).downfall(downfall.floatValue()).temperatureAdjustment((Biome.TemperatureModifier)temperatureModifier).specialEffects(effectsBuilder.build()).mobSpawnSettings(spawnerBuilder.build()).generationSettings(generationBuilder.build());
            return new SpongeBiomeTemplate(this.key, vanillaBuilder.build(), this.pack);
        }
    }
}

