/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.gen.WorldGenSettingsAccessor;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeWorldGenerationConfigBuilder
implements WorldGenerationConfig.Builder {
    private long seed;
    private boolean generateFeatures;
    private boolean generateBonusChest;

    @Override
    public WorldGenerationConfig.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public void seed(String seed) {
        this.seed = SeedUtil.compute(seed);
    }

    @Override
    public WorldGenerationConfig.Builder generateStructures(boolean generateStructures) {
        this.generateFeatures = generateStructures;
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder generateBonusChest(boolean generateBonusChest) {
        this.generateBonusChest = generateBonusChest;
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder reset() {
        WorldGenSettings defaultSettings = SpongeCommon.server().getWorldData().worldGenSettings();
        this.seed = defaultSettings.seed();
        this.generateFeatures = defaultSettings.generateStructures();
        this.generateBonusChest = defaultSettings.generateBonusChest();
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder from(WorldGenerationConfig value) {
        this.seed = Objects.requireNonNull(value, "value").seed();
        this.generateFeatures = value.generateStructures();
        this.generateBonusChest = value.generateBonusChest();
        return this;
    }

    public WorldGenerationConfig build() {
        return (WorldGenerationConfig)WorldGenSettingsAccessor.invoker$new(this.seed, this.generateFeatures, this.generateBonusChest, (Registry<LevelStem>)new MappedRegistry(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), null), Optional.empty());
    }
}

