/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.config.noise.DensityFunctionTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeDensityFunctionTemplate
extends Record
implements DensityFunctionTemplate {
    private final ResourceKey key;
    private final DensityFunction representedFunction;
    private final DataPack<DensityFunctionTemplate> pack;

    public SpongeDensityFunctionTemplate(ResourceKey key, DensityFunction representedFunction, DataPack<DensityFunctionTemplate> pack) {
        this.key = key;
        this.representedFunction = representedFunction;
        this.pack = pack;
    }

    @Override
    public org.spongepowered.api.world.generation.config.noise.DensityFunction densityFunction() {
        return (org.spongepowered.api.world.generation.config.noise.DensityFunction)this.representedFunction;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeDensityFunctionTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Density Function:\n" + serialized, e);
        }
    }

    public static JsonElement encode(DensityFunctionTemplate template, RegistryAccess registryAccess) {
        return (JsonElement)DensityFunction.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((DensityFunction)template.densityFunction())).getOrThrow(false, e -> {});
    }

    public static DensityFunction decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (DensityFunction)DensityFunction.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static SpongeDensityFunctionTemplate decode(DataPack<DensityFunctionTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        DensityFunction parsed = SpongeDensityFunctionTemplate.decode(packEntry, registryAccess);
        return new SpongeDensityFunctionTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeDensityFunctionTemplate.class, "key;representedFunction;pack", "key", "representedFunction", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeDensityFunctionTemplate.class, "key;representedFunction;pack", "key", "representedFunction", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeDensityFunctionTemplate.class, "key;representedFunction;pack", "key", "representedFunction", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public DensityFunction representedFunction() {
        return this.representedFunction;
    }

    @Override
    public DataPack<DensityFunctionTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<org.spongepowered.api.world.generation.config.noise.DensityFunction, DensityFunctionTemplate, DensityFunctionTemplate.Builder>
    implements DensityFunctionTemplate.Builder {
        private @Nullable DensityFunction densityFunction;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<DensityFunctionTemplate, org.spongepowered.api.world.generation.config.noise.DensityFunction> valueExtractor() {
            return DensityFunctionTemplate::densityFunction;
        }

        @Override
        public DensityFunctionTemplate.Builder fromValue(org.spongepowered.api.world.generation.config.noise.DensityFunction densityFunction) {
            this.densityFunction = (DensityFunction)densityFunction;
            return this;
        }

        @Override
        public DensityFunctionTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            this.densityFunction = SpongeDensityFunctionTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            return this;
        }

        @Override
        public DensityFunctionTemplate.Builder reset() {
            this.pack = DataPacks.DENSITY_FUNCTION;
            this.key = null;
            this.densityFunction = null;
            return this;
        }

        @Override
        protected SpongeDensityFunctionTemplate build0() {
            Objects.requireNonNull(this.densityFunction, "densityFunction");
            return new SpongeDensityFunctionTemplate(this.key, this.densityFunction, this.pack);
        }
    }
}

