/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.config.noise.Noise;
import org.spongepowered.api.world.generation.config.noise.NoiseTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeNoiseTemplate
extends Record
implements NoiseTemplate {
    private final ResourceKey key;
    private final NormalNoise.NoiseParameters noiseParameters;
    private final DataPack<NoiseTemplate> pack;

    public SpongeNoiseTemplate(ResourceKey key, NormalNoise.NoiseParameters noiseParameters, DataPack<NoiseTemplate> pack) {
        this.key = key;
        this.noiseParameters = noiseParameters;
        this.pack = pack;
    }

    @Override
    public Noise noise() {
        return (Noise)this.noiseParameters;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeNoiseTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Noise:\n" + serialized, e);
        }
    }

    public static JsonElement encode(NoiseTemplate template, RegistryAccess registryAccess) {
        return (JsonElement)NormalNoise.NoiseParameters.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((NormalNoise.NoiseParameters)template.noise())).getOrThrow(false, e -> {});
    }

    public static NormalNoise.NoiseParameters decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (NormalNoise.NoiseParameters)NormalNoise.NoiseParameters.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static SpongeNoiseTemplate decode(DataPack<NoiseTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        NormalNoise.NoiseParameters parsed = SpongeNoiseTemplate.decode(packEntry, registryAccess);
        return new SpongeNoiseTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public NormalNoise.NoiseParameters noiseParameters() {
        return this.noiseParameters;
    }

    @Override
    public DataPack<NoiseTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<Noise, NoiseTemplate, NoiseTemplate.Builder>
    implements NoiseTemplate.Builder {
        private @Nullable Integer octave;
        private @Nullable List<Double> amplitudes;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseTemplate.Builder fromValue(Noise noise) {
            this.octave(noise.octave()).amplitudes(noise.amplitudes());
            return this;
        }

        @Override
        public NoiseTemplate.Builder octave(int octave) {
            this.octave = octave;
            return this;
        }

        @Override
        public NoiseTemplate.Builder amplitudes(double ... amplitudes) {
            this.amplitudes = DoubleStream.of(amplitudes).boxed().toList();
            return this;
        }

        @Override
        public NoiseTemplate.Builder amplitudes(List<Double> amplitudes) {
            this.amplitudes = amplitudes;
            return this;
        }

        @Override
        public NoiseTemplate.Builder reset() {
            this.octave = null;
            this.amplitudes = null;
            this.pack = DataPacks.NOISE;
            this.key = null;
            return this;
        }

        @Override
        public NoiseTemplate.Builder fromDataPack(DataView datapack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(datapack));
            return this.fromValue((Noise)SpongeNoiseTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess()));
        }

        @Override
        public Function<NoiseTemplate, Noise> valueExtractor() {
            return NoiseTemplate::noise;
        }

        @Override
        protected SpongeNoiseTemplate build0() {
            Objects.requireNonNull(this.octave, "octave");
            Objects.requireNonNull(this.amplitudes, "amplitudes");
            NormalNoise.NoiseParameters params = new NormalNoise.NoiseParameters(this.octave.intValue(), new ArrayList<Double>(this.amplitudes));
            return new SpongeNoiseTemplate(this.key, params, this.pack);
        }
    }
}

