/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.world.generation.structure.StructurePlacement;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

public class SpongeStructurePlacementBuilder
implements StructurePlacement.Builder,
StructurePlacement.Builder.RandomSpread,
StructurePlacement.Builder.ConcentricRings {
    private Boolean randomSpread;
    private Vec3i locateOffset = Vec3i.ZERO;
    private int salt = 0;
    private Integer spacing;
    private Integer separation;
    private RandomSpreadType randomSpreadType = RandomSpreadType.LINEAR;
    private Integer distance;
    private Integer spread;
    private Integer count;
    private HolderSet<Biome> preferredBiomes = HolderSet.direct((Holder[])new Holder[0]);

    @Override
    public StructurePlacement.Builder reset() {
        this.randomSpread = null;
        this.locateOffset = Vec3i.ZERO;
        this.spacing = null;
        this.separation = null;
        this.salt = 0;
        this.randomSpreadType = RandomSpreadType.LINEAR;
        this.distance = null;
        this.spread = null;
        this.count = null;
        this.preferredBiomes = HolderSet.direct((Holder[])new Holder[0]);
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread randomSpread(Vector3i locateOffset, int salt) {
        this.randomSpread = true;
        this.salt = salt;
        this.locateOffset = VecHelper.toVanillaVector3i(locateOffset);
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread randomSpread(int salt) {
        this.randomSpread = true;
        this.salt = salt;
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread linear() {
        this.randomSpreadType = RandomSpreadType.LINEAR;
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread triangular() {
        this.randomSpreadType = RandomSpreadType.TRIANGULAR;
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    @Override
    public StructurePlacement.Builder.RandomSpread separation(int separation) {
        this.separation = separation;
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings concentricRings() {
        this.randomSpread = false;
        this.salt = 0;
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings concentricRings(Vector3i locateOffset, int salt) {
        this.randomSpread = false;
        this.salt = salt;
        this.locateOffset = VecHelper.toVanillaVector3i(locateOffset);
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings distance(int distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings spread(int spread) {
        this.spread = spread;
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings count(int count) {
        this.count = count;
        return this;
    }

    @Override
    public StructurePlacement.Builder.ConcentricRings preferredBiomes(Tag<org.spongepowered.api.world.biome.Biome> preferredBiomes) {
        Registry registry = SpongeCommon.server().registryAccess().registryOrThrow(Registry.BIOME_REGISTRY);
        this.preferredBiomes = registry.getOrCreateTag((TagKey)preferredBiomes);
        return this;
    }

    @Override
    public StructurePlacement build() {
        StructurePlacement.FrequencyReductionMethod method = StructurePlacement.FrequencyReductionMethod.DEFAULT;
        float frequency = 1.0f;
        Optional exclusionZone = Optional.empty();
        if (this.randomSpread.booleanValue()) {
            Objects.requireNonNull(this.spacing, "spacing");
            Objects.requireNonNull(this.separation, "spacing");
            return (StructurePlacement)new RandomSpreadStructurePlacement(this.locateOffset, method, 1.0f, this.salt, exclusionZone, this.spacing.intValue(), this.separation.intValue(), this.randomSpreadType);
        }
        Objects.requireNonNull(this.distance, "distance");
        Objects.requireNonNull(this.spread, "spread");
        Objects.requireNonNull(this.count, "count");
        return (StructurePlacement)new ConcentricRingsStructurePlacement(this.locateOffset, method, 1.0f, this.salt, exclusionZone, this.distance.intValue(), this.spread.intValue(), this.count.intValue(), this.preferredBiomes);
    }
}

