/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.StructureSet;
import org.spongepowered.api.world.generation.structure.StructureSetTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeStructureSetTemplate
extends Record
implements StructureSetTemplate {
    private final ResourceKey key;
    private final net.minecraft.world.level.levelgen.structure.StructureSet representedStructureSet;
    private final DataPack<StructureSetTemplate> pack;

    public SpongeStructureSetTemplate(ResourceKey key, net.minecraft.world.level.levelgen.structure.StructureSet representedStructureSet, DataPack<StructureSetTemplate> pack) {
        this.key = key;
        this.representedStructureSet = representedStructureSet;
        this.pack = pack;
    }

    @Override
    public StructureSet structureSet() {
        return (StructureSet)this.representedStructureSet;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeStructureSetTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + serialized, e);
        }
    }

    public static JsonElement encode(StructureSetTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (JsonElement)net.minecraft.world.level.levelgen.structure.StructureSet.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((net.minecraft.world.level.levelgen.structure.StructureSet)template.structureSet())).getOrThrow(false, e -> {});
    }

    public static net.minecraft.world.level.levelgen.structure.StructureSet decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (net.minecraft.world.level.levelgen.structure.StructureSet)net.minecraft.world.level.levelgen.structure.StructureSet.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static SpongeStructureSetTemplate decode(DataPack<StructureSetTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        net.minecraft.world.level.levelgen.structure.StructureSet parsed = SpongeStructureSetTemplate.decode(packEntry, registryAccess);
        return new SpongeStructureSetTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public net.minecraft.world.level.levelgen.structure.StructureSet representedStructureSet() {
        return this.representedStructureSet;
    }

    @Override
    public DataPack<StructureSetTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<StructureSet, StructureSetTemplate, StructureSetTemplate.Builder>
    implements StructureSetTemplate.Builder {
        private @Nullable StructurePlacement placement;
        private List<StructureSet.StructureSelectionEntry> structureSelectionEntries = new ArrayList<StructureSet.StructureSelectionEntry>();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<StructureSetTemplate, StructureSet> valueExtractor() {
            return StructureSetTemplate::structureSet;
        }

        @Override
        public StructureSetTemplate.Builder fromValue(StructureSet structureSet) {
            net.minecraft.world.level.levelgen.structure.StructureSet mcSet = (net.minecraft.world.level.levelgen.structure.StructureSet)structureSet;
            this.structureSelectionEntries = mcSet.structures();
            this.placement = mcSet.placement();
            return this;
        }

        @Override
        public StructureSetTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            net.minecraft.world.level.levelgen.structure.StructureSet decoded = SpongeStructureSetTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.structureSelectionEntries = decoded.structures();
            this.placement = decoded.placement();
            return this;
        }

        @Override
        public StructureSetTemplate.Builder placement(org.spongepowered.api.world.generation.structure.StructurePlacement placement) {
            this.placement = (StructurePlacement)placement;
            return this;
        }

        @Override
        public StructureSetTemplate.Builder add(org.spongepowered.api.world.generation.structure.Structure structure, int weight) {
            Holder.Reference holder;
            Registry registry = SpongeCommon.server().registryAccess().registryOrThrow(Registry.STRUCTURE_REGISTRY);
            Structure mcStructure = (Structure)structure;
            try {
                holder = registry.createIntrusiveHolder((Object)mcStructure);
            }
            catch (Exception e) {
                holder = Holder.direct((Object)mcStructure);
            }
            this.structureSelectionEntries.add(new StructureSet.StructureSelectionEntry((Holder)holder, weight));
            return this;
        }

        @Override
        public StructureSetTemplate.Builder reset() {
            super.reset();
            this.pack = DataPacks.STRUCTURE_SET;
            this.placement = null;
            this.structureSelectionEntries = new ArrayList<StructureSet.StructureSelectionEntry>();
            return this;
        }

        @Override
        protected SpongeStructureSetTemplate build0() {
            Objects.requireNonNull(this.placement, "placement");
            return new SpongeStructureSetTemplate(this.key, new net.minecraft.world.level.levelgen.structure.StructureSet(this.structureSelectionEntries, this.placement), this.pack);
        }
    }
}

