/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.StructureTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeStructureTemplate
extends Record
implements StructureTemplate {
    private final ResourceKey key;
    private final Structure representedStructure;
    private final DataPack<StructureTemplate> pack;

    public SpongeStructureTemplate(ResourceKey key, Structure representedStructure, DataPack<StructureTemplate> pack) {
        this.key = key;
        this.representedStructure = representedStructure;
        this.pack = pack;
    }

    @Override
    public org.spongepowered.api.world.generation.structure.Structure structure() {
        return (org.spongepowered.api.world.generation.structure.Structure)this.representedStructure;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeStructureTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + serialized, e);
        }
    }

    public static JsonElement encode(StructureTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (JsonElement)Structure.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((Structure)template.structure())).getOrThrow(false, e -> {});
    }

    public static Structure decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (Structure)Structure.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static SpongeStructureTemplate decode(DataPack<StructureTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        Structure parsed = SpongeStructureTemplate.decode(packEntry, registryAccess);
        return new SpongeStructureTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public Structure representedStructure() {
        return this.representedStructure;
    }

    @Override
    public DataPack<StructureTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<org.spongepowered.api.world.generation.structure.Structure, StructureTemplate, StructureTemplate.Builder>
    implements StructureTemplate.Builder {
        private @Nullable Structure structure;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<StructureTemplate, org.spongepowered.api.world.generation.structure.Structure> valueExtractor() {
            return StructureTemplate::structure;
        }

        @Override
        public StructureTemplate.Builder fromValue(org.spongepowered.api.world.generation.structure.Structure structure) {
            this.structure = (Structure)structure;
            return this;
        }

        @Override
        public StructureTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            this.structure = SpongeStructureTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            return this;
        }

        @Override
        public StructureTemplate.Builder reset() {
            this.key = null;
            this.pack = DataPacks.STRUCTURE;
            this.structure = null;
            return this;
        }

        @Override
        protected SpongeStructureTemplate build0() {
            Objects.requireNonNull(this.structure, "Structure");
            return new SpongeStructureTemplate(this.key, this.structure, this.pack);
        }
    }
}

