/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure.jigsaw;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.generation.structure.jigsaw.JigsawPool;
import org.spongepowered.api.world.generation.structure.jigsaw.JigsawPoolElement;
import org.spongepowered.api.world.generation.structure.jigsaw.JigsawPoolTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.levelgen.structure.pools.StructureTemplatePoolAccessor;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeJigsawPoolTemplate
extends Record
implements JigsawPoolTemplate {
    private final ResourceKey key;
    private final StructureTemplatePool representedJigsawPool;
    private final DataPack<JigsawPoolTemplate> pack;

    public SpongeJigsawPoolTemplate(ResourceKey key, StructureTemplatePool representedJigsawPool, DataPack<JigsawPoolTemplate> pack) {
        this.key = key;
        this.representedJigsawPool = representedJigsawPool;
        this.pack = pack;
    }

    @Override
    public JigsawPool jigsawPool() {
        return (JigsawPool)this.representedJigsawPool;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeJigsawPoolTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + serialized, e);
        }
    }

    public static JsonElement encode(JigsawPoolTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (JsonElement)StructureTemplatePool.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((StructureTemplatePool)template.jigsawPool())).getOrThrow(false, e -> {});
    }

    public static StructureTemplatePool decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (StructureTemplatePool)StructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static SpongeJigsawPoolTemplate decode(DataPack<JigsawPoolTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        StructureTemplatePool parsed = SpongeJigsawPoolTemplate.decode(packEntry, registryAccess);
        return new SpongeJigsawPoolTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeJigsawPoolTemplate.class, "key;representedJigsawPool;pack", "key", "representedJigsawPool", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeJigsawPoolTemplate.class, "key;representedJigsawPool;pack", "key", "representedJigsawPool", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeJigsawPoolTemplate.class, "key;representedJigsawPool;pack", "key", "representedJigsawPool", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public StructureTemplatePool representedJigsawPool() {
        return this.representedJigsawPool;
    }

    @Override
    public DataPack<JigsawPoolTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<JigsawPool, JigsawPoolTemplate, JigsawPoolTemplate.Builder>
    implements JigsawPoolTemplate.Builder {
        private ResourceLocation name;
        private ResourceLocation fallback;
        private List<Pair<StructurePoolElement, Integer>> templates;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<JigsawPoolTemplate, JigsawPool> valueExtractor() {
            return JigsawPoolTemplate::jigsawPool;
        }

        @Override
        public JigsawPoolTemplate.Builder fromValue(JigsawPool StructureTemplatePool2) {
            StructureTemplatePool mcPool = (StructureTemplatePool)StructureTemplatePool2;
            this.name = mcPool.getName();
            this.fallback = mcPool.getFallback();
            this.templates = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)mcPool).accessor$rawTemplates());
            return this;
        }

        @Override
        public JigsawPoolTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            StructureTemplatePool decoded = SpongeJigsawPoolTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            return this.fromValue((JigsawPool)decoded);
        }

        @Override
        public JigsawPoolTemplate.Builder add(JigsawPoolElement element, int weight) {
            this.templates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)element), (Object)weight));
            return this;
        }

        @Override
        public JigsawPoolTemplate.Builder name(ResourceKey name) {
            this.name = (ResourceLocation)name;
            return this;
        }

        @Override
        public JigsawPoolTemplate.Builder fallback(RegistryReference<JigsawPool> fallback) {
            this.fallback = (ResourceLocation)fallback.location();
            return this;
        }

        @Override
        public JigsawPoolTemplate.Builder fallback(JigsawPoolTemplate fallback) {
            this.fallback = (ResourceLocation)fallback.key();
            return this;
        }

        @Override
        public JigsawPoolTemplate.Builder reset() {
            super.reset();
            this.pack = DataPacks.JIGSAW_POOL;
            this.name = null;
            this.fallback = new ResourceLocation("empty");
            this.templates = new ArrayList<Pair<StructurePoolElement, Integer>>();
            return this;
        }

        @Override
        protected SpongeJigsawPoolTemplate build0() {
            Objects.requireNonNull(this.name, "name");
            return new SpongeJigsawPoolTemplate(this.key, new StructureTemplatePool(this.name, this.fallback, this.templates), this.pack);
        }
    }
}

