/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.lang.runtime.ObjectMethods;
import java.util.OptionalLong;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;
import org.spongepowered.common.world.server.SpongeDimensionTypes;

public final class SpongeWorldTypeTemplate
extends Record
implements WorldTypeTemplate {
    private final ResourceKey key;
    private final DimensionType dimensionType;
    private final DataPack<WorldTypeTemplate> pack;

    public SpongeWorldTypeTemplate(ResourceKey key, DimensionType dimensionType, DataPack<WorldTypeTemplate> pack) {
        this.key = key;
        this.dimensionType = dimensionType;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeWorldTypeTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            DataContainer container = DataFormats.JSON.get().read(serialized.toString());
            container.set(Queries.CONTENT_VERSION, this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized DimensionType:\n" + serialized, e);
        }
    }

    @Override
    public WorldType worldType() {
        return (WorldType)this.dimensionType;
    }

    public static JsonElement encode(WorldTypeTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (JsonElement)SpongeDimensionTypes.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((DimensionType)template.worldType())).getOrThrow(false, e -> {});
    }

    public static DimensionType decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        return (DimensionType)SpongeDimensionTypes.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static WorldTypeTemplate decode(DataPack<WorldTypeTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        DimensionType parsed = SpongeWorldTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeWorldTypeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public DimensionType dimensionType() {
        return this.dimensionType;
    }

    @Override
    public DataPack<WorldTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<WorldType, WorldTypeTemplate, WorldTypeTemplate.Builder>
    implements WorldTypeTemplate.Builder {
        private static DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(DimensionType.class);
        private DataManipulator.Mutable manipulator = DataManipulator.mutableOf();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<WorldTypeTemplate, WorldType> valueExtractor() {
            return WorldTypeTemplate::worldType;
        }

        @Override
        public <V> WorldTypeTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported((Type)((Object)DimensionType.class))) {
                throw new IllegalArgumentException(key + " is not supported for world types");
            }
            this.manipulator.set(key, value);
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder reset() {
            this.manipulator = DataManipulator.mutableOf();
            this.key = null;
            this.pack = DataPacks.WORLD_TYPE;
            DimensionType defaultOverworld = (DimensionType)SpongeCommon.server().registryAccess().registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY).get(BuiltinDimensionTypes.OVERWORLD);
            this.fromValue((WorldType)defaultOverworld);
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder fromValue(WorldType type) {
            this.manipulator.set(type.getValues());
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            DataResult parsed = DimensionType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            DimensionType dimensionType = (DimensionType)((Holder)parsed.getOrThrow(false, e -> {})).value();
            this.fromValue((WorldType)dimensionType);
            return this;
        }

        @Override
        public @NonNull WorldTypeTemplate build0() {
            @Nullable WorldTypeEffect effect = this.manipulator.getOrNull(Keys.WORLD_TYPE_EFFECT);
            boolean scorching = this.manipulator.require(Keys.SCORCHING);
            boolean natural = this.manipulator.require(Keys.NATURAL_WORLD_TYPE);
            double coordinateMultiplier = this.manipulator.require(Keys.COORDINATE_MULTIPLIER);
            boolean hasSkylight = this.manipulator.require(Keys.HAS_SKYLIGHT);
            boolean hasCeiling = this.manipulator.require(Keys.HAS_CEILING);
            float ambientLighting = this.manipulator.require(Keys.AMBIENT_LIGHTING).floatValue();
            @Nullable MinecraftDayTime fixedTime = this.manipulator.getOrNull(Keys.FIXED_TIME);
            boolean bedsUsable = this.manipulator.require(Keys.BEDS_USABLE);
            boolean respawnAnchorsUsable = this.manipulator.require(Keys.RESPAWN_ANCHOR_USABLE);
            int floor = this.manipulator.require(Keys.WORLD_FLOOR);
            int height = this.manipulator.require(Keys.WORLD_HEIGHT);
            int logicalHeight = this.manipulator.require(Keys.WORLD_LOGICAL_HEIGHT);
            @Nullable Tag<BlockType> infiniburn = this.manipulator.getOrNull(Keys.INFINIBURN);
            boolean piglinSafe = this.manipulator.require(Keys.PIGLIN_SAFE);
            boolean hasRaids = this.manipulator.require(Keys.HAS_RAIDS);
            int monsterSpawnBlockLightLimit = this.manipulator.getOrElse(Keys.SPAWN_LIGHT_LIMIT, 0);
            Range<Integer> lightRange = this.manipulator.getOrElse(Keys.SPAWN_LIGHT_RANGE, Range.intRange(0, 7));
            boolean createDragonFight = this.manipulator.getOrElse(Keys.CREATE_DRAGON_FIGHT, false);
            UniformInt monsterSpawnLightTest = UniformInt.of((int)lightRange.min(), (int)lightRange.max());
            SpongeDimensionTypes.SpongeDataSection spongeData = new SpongeDimensionTypes.SpongeDataSection(createDragonFight);
            try {
                DimensionType dimensionType;
                DimensionType dimensionType2 = dimensionType = new DimensionType(fixedTime == null ? OptionalLong.empty() : OptionalLong.of(fixedTime.asTicks().ticks()), hasSkylight, hasCeiling, scorching, natural, coordinateMultiplier, bedsUsable, respawnAnchorsUsable, floor, height, logicalHeight, (TagKey)infiniburn, (ResourceLocation)effect.key(), ambientLighting, new DimensionType.MonsterSettings(piglinSafe, hasRaids, (IntProvider)monsterSpawnLightTest, monsterSpawnBlockLightLimit));
                if (dimensionType2 instanceof DimensionTypeBridge) {
                    DimensionTypeBridge bridge = (DimensionTypeBridge)dimensionType2;
                    bridge.bridge$decorateData(spongeData);
                }
                return new SpongeWorldTypeTemplate(this.key, dimensionType, this.pack);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.format("Template '%s' was not valid!", this.key), e);
            }
        }
    }
}

