/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.weather;

import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.weather.SpongeWeatherType;

public final class SpongeWeather
implements Weather {
    private final SpongeWeatherType type;
    private final Ticks remainingDuration;
    private final Ticks runningDuration;

    public SpongeWeather(SpongeWeatherType type, Ticks remainingDuration, Ticks runningDuration) {
        this.type = type;
        this.remainingDuration = remainingDuration;
        this.runningDuration = runningDuration;
    }

    public static Weather of(ServerLevelData levelData) {
        boolean thundering = levelData.isThundering();
        if (thundering) {
            int thunderTime = levelData.getThunderTime();
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.THUNDER.get(), new SpongeTicks(thunderTime), new SpongeTicks(6000 - thunderTime));
        }
        boolean raining = levelData.isRaining();
        if (raining) {
            int rainTime = levelData.getRainTime();
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.RAIN.get(), new SpongeTicks(rainTime), new SpongeTicks(6000 - rainTime));
        }
        int clearWeatherTime = levelData.getClearWeatherTime();
        return new SpongeWeather((SpongeWeatherType)WeatherTypes.CLEAR.get(), new SpongeTicks(clearWeatherTime), new SpongeTicks(6000 - clearWeatherTime));
    }

    public static void apply(ServerLevelData levelData, Weather weather) {
        long time = weather.remainingDuration().ticks();
        WeatherType type = weather.type();
        if (type == WeatherTypes.CLEAR.get()) {
            levelData.setClearWeatherTime((int)time);
            levelData.setRaining(false);
            levelData.setRainTime(0);
            levelData.setThundering(false);
            levelData.setThunderTime(0);
        } else if (type == WeatherTypes.RAIN.get()) {
            levelData.setRaining(true);
            levelData.setRainTime((int)time);
            levelData.setThundering(false);
            levelData.setThunderTime(0);
            levelData.setClearWeatherTime(0);
        } else if (type == WeatherTypes.THUNDER.get()) {
            levelData.setRaining(true);
            levelData.setRainTime((int)time);
            levelData.setThundering(true);
            levelData.setThunderTime((int)time);
            levelData.setClearWeatherTime(0);
        }
    }

    @Override
    public WeatherType type() {
        return this.type;
    }

    @Override
    public Ticks remainingDuration() {
        return this.remainingDuration;
    }

    @Override
    public Ticks runningDuration() {
        return this.runningDuration;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Universe.Weather.TYPE, this.type.key(RegistryTypes.WEATHER_TYPE)).set(Constants.Universe.Weather.REMAINING_DURATION, this.remainingDuration.ticks()).set(Constants.Universe.Weather.RUNNING_DURATION, this.runningDuration.ticks());
    }

    public static class FactoryImpl
    implements Weather.Factory {
        @Override
        public Weather of(WeatherType type, Ticks remainingDuration, Ticks runningDuration) {
            return new SpongeWeather((SpongeWeatherType)type, remainingDuration, runningDuration);
        }
    }
}

