/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch.plugin;

import com.google.inject.Singleton;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.common.launch.plugin.SpongePluginManager;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginLoader;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.metadata.model.PluginDependency;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;
import org.spongepowered.vanilla.launch.VanillaLaunch;
import org.spongepowered.vanilla.launch.plugin.VanillaDummyPluginContainer;
import org.spongepowered.vanilla.launch.plugin.resolver.DependencyResolver;
import org.spongepowered.vanilla.launch.plugin.resolver.ResolutionResult;

@Singleton
public final class VanillaPluginManager
implements SpongePluginManager {
    private final Map<String, PluginContainer> plugins = new Object2ObjectOpenHashMap();
    private final Map<Object, PluginContainer> instancesToPlugins = new IdentityHashMap<Object, PluginContainer>();
    private final List<PluginContainer> sortedPlugins = new ArrayList<PluginContainer>();
    private final Map<String, Set<PluginResource>> locatedResources = new Object2ObjectOpenHashMap();
    private final Map<PluginContainer, PluginResource> containerToResource = new Object2ObjectOpenHashMap();

    @Override
    public Optional<PluginContainer> fromInstance(Object instance) {
        return Optional.ofNullable(this.instancesToPlugins.get(Objects.requireNonNull(instance, "instance")));
    }

    @Override
    public Optional<PluginContainer> plugin(String id) {
        return Optional.ofNullable(this.plugins.get(Objects.requireNonNull(id, "id")));
    }

    @Override
    public Collection<PluginContainer> plugins() {
        return Collections.unmodifiableCollection(this.sortedPlugins);
    }

    public void loadPlugins(VanillaPluginPlatform platform) {
        this.locatedResources.putAll(platform.getResources());
        HashMap pluginLanguageLookup = new HashMap();
        HashMap<PluginLanguageService<PluginResource>, PluginLoader> pluginLoaders = new HashMap<PluginLanguageService<PluginResource>, PluginLoader>();
        for (Map.Entry<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> candidate : platform.getCandidates().entrySet()) {
            PluginLanguageService<PluginResource> languageService = candidate.getKey();
            String loaderClass = languageService.pluginLoader();
            try {
                pluginLoaders.put(languageService, (PluginLoader)Class.forName(loaderClass).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            candidate.getValue().forEach(x -> pluginLanguageLookup.put(x, languageService));
        }
        LinkedHashSet resources = new LinkedHashSet();
        pluginLanguageLookup.keySet().stream().filter(x -> this.plugins.containsKey(x.metadata().id())).forEach(resources::add);
        resources.addAll(pluginLanguageLookup.keySet());
        ResolutionResult<PluginResource> resolutionResult = DependencyResolver.resolveAndSortCandidates(resources, platform.logger());
        HashMap failedInstances = new HashMap();
        HashMap<PluginCandidate<PluginResource>, String> consequentialFailedInstances = new HashMap<PluginCandidate<PluginResource>, String>();
        ClassLoader launchClassloader = VanillaLaunch.instance().getClass().getClassLoader();
        for (PluginCandidate candidate : resolutionResult.sortedSuccesses()) {
            PluginContainer plugin = this.plugins.get(candidate.metadata().id());
            if (plugin != null) {
                if (plugin instanceof VanillaDummyPluginContainer) continue;
                resolutionResult.duplicateIds().add(candidate.metadata().id());
                PrettyPrinter prettyPrinter = new PrettyPrinter(120).add("ATTEMPTED TO CREATE PLUGIN WITH DUPLICATE PLUGIN ID").centre().hr().addWrapped("Sponge attempted to create a second plugin with ID '%s'. This is not allowed - all plugins must have a unique ID. Usually, Sponge will catch this earlier -- but in this case Sponge has validated two plugins with the same ID. Please report this error to Sponge.", candidate.metadata().id()).add().add("Technical Details:").add((Object)"Plugins to load:", 4);
                resolutionResult.sortedSuccesses().forEach(x -> prettyPrinter.add((Object)("*" + x.metadata().id()), 4));
                prettyPrinter.add().add((Object)"Detected Duplicate IDs:", 4);
                resolutionResult.duplicateIds().forEach(x -> prettyPrinter.add((Object)("*" + x), 4));
                prettyPrinter.log(platform.logger(), Level.ERROR);
                continue;
            }
            if (!this.stillValid(candidate, consequentialFailedInstances)) continue;
            PluginLanguageService languageService = (PluginLanguageService)pluginLanguageLookup.get(candidate);
            PluginLoader pluginLoader = (PluginLoader)pluginLoaders.get(languageService);
            try {
                PluginContainer container = pluginLoader.loadPlugin((Environment)platform.getStandardEnvironment(), candidate, launchClassloader);
                this.addPlugin(container);
                this.containerToResource.put(container, candidate.resource());
            }
            catch (InvalidPluginException e) {
                failedInstances.put(candidate, "Failed to construct: see stacktrace(s) above this message for details.");
                platform.logger().error("Failed to construct plugin {}", (Object)candidate.metadata().id(), (Object)e);
            }
        }
        resolutionResult.printErrorsIfAny(failedInstances, consequentialFailedInstances, platform.logger());
        platform.logger().info("Loaded plugin(s): {}", this.sortedPlugins.stream().map(p -> p.metadata().id()).collect(Collectors.toList()));
    }

    public void addPlugin(PluginContainer plugin) {
        this.plugins.put(plugin.metadata().id(), Objects.requireNonNull(plugin, "plugin"));
        this.sortedPlugins.add(plugin);
        if (!(plugin instanceof VanillaDummyPluginContainer)) {
            this.instancesToPlugins.put(plugin.instance(), plugin);
        }
    }

    public Map<String, Set<PluginResource>> locatedResources() {
        return Collections.unmodifiableMap(this.locatedResources);
    }

    @Nullable
    public PluginResource resource(PluginContainer container) {
        return this.containerToResource.get(container);
    }

    private boolean stillValid(PluginCandidate<PluginResource> candidate, Map<PluginCandidate<PluginResource>, String> consequential) {
        Optional<PluginDependency> failedId = candidate.metadata().dependencies().stream().filter(x -> !x.optional() && !this.plugins.containsKey(x.id())).findFirst();
        if (failedId.isPresent()) {
            consequential.put(candidate, failedId.get().id());
            return false;
        }
        return true;
    }
}

