/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.client;

import com.mojang.blaze3d.platform.Window;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.vanilla.client.VanillaClient;
import org.spongepowered.vanilla.util.WindowUtils;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin_Vanilla
implements MinecraftBridge,
VanillaClient {
    @Override
    public ClientType bridge$getClientType() {
        return ClientType.SPONGE_VANILLA;
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void vanilla$establishRegistriesAndStartingEngine(CallbackInfo ci) {
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.establishGlobalRegistries();
        lifecycle.establishDataProviders();
        lifecycle.callRegisterDataEvent();
        lifecycle.establishClientRegistries(this);
        lifecycle.callStartingEngineEvent(this);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/packs/VanillaPackResources;getResource(Lnet/minecraft/server/packs/PackType;Lnet/minecraft/resources/ResourceLocation;)Ljava/io/InputStream;"))
    private InputStream vanilla$skipLoadingVanillaIcon(VanillaPackResources vanillaPackResources, PackType param0, ResourceLocation param1) {
        return null;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setIcon(Ljava/io/InputStream;Ljava/io/InputStream;)V"))
    private void vanilla$useSpongeIcon(Window window, InputStream param0, InputStream param1) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("spongie_icon.png");){
            WindowUtils.setWindowIcon(window.getWindow(), stream);
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to set window icon", (Throwable)e);
        }
    }
}

