/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.level;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.SpongePacketHandler;
import org.spongepowered.common.world.portal.PortalLogic;
import org.spongepowered.vanilla.mixin.core.world.entity.LivingEntityMixin_Vanilla;

@Mixin(value={net.minecraft.server.level.ServerPlayer.class})
public abstract class ServerPlayerMixin_Vanilla
extends LivingEntityMixin_Vanilla
implements ServerPlayerBridge {
    @Override
    public void bridge$sendViewerEnvironment(DimensionType dimensionType) {
        if (this.bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            SpongePacketHandler.getChannel().sendTo((ServerPlayer)((Object)this), (Packet)new ChangeViewerEnvironmentPacket(dimensionType));
        }
    }

    @Override
    @Overwrite
    @Nullable
    public Entity changeDimension(ServerLevel target) {
        return this.bridge$changeDimension(target, (PortalLogic)target.getPortalForcer());
    }

    @Override
    protected void vanilla$onElytraUse(CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)this;
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect((Player)player, PlayerInventoryTransaction.EventCreator.STANDARD);){
            player.inventoryMenu.broadcastChanges();
        }
    }
}

