/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.util;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public final class WindowUtils {
    public static void setWindowIcon(long windowRef, InputStream stream) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer iconWidth = stack.mallocInt(1);
            IntBuffer iconHeight = stack.mallocInt(1);
            IntBuffer iconChannels = stack.mallocInt(1);
            GLFWImage.Buffer glfwImages = GLFWImage.mallocStack((int)1, (MemoryStack)stack);
            try {
                byte[] icon = ByteStreams.toByteArray((InputStream)stream);
                ByteBuffer iconBuf = stack.malloc(icon.length);
                iconBuf.put(icon);
                iconBuf.position(0);
                ByteBuffer imgBuffer = STBImage.stbi_load_from_memory((ByteBuffer)iconBuf, (IntBuffer)iconWidth, (IntBuffer)iconHeight, (IntBuffer)iconChannels, (int)4);
                if (imgBuffer == null) {
                    throw new NullPointerException("Failed to load window icon");
                }
                glfwImages.position(0);
                glfwImages.width(iconWidth.get(0));
                glfwImages.height(iconHeight.get(0));
                imgBuffer.position(0);
                glfwImages.pixels(imgBuffer);
                glfwImages.position(0);
                GLFW.glfwSetWindowIcon((long)windowRef, (GLFWImage.Buffer)glfwImages);
                STBImage.stbi_image_free((ByteBuffer)imgBuffer);
            }
            catch (IOException | NullPointerException var29) {
                System.err.println("Failed to load spongie logo");
            }
        }
    }

    private WindowUtils() {
    }
}

