/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume;

import java.util.Objects;
import org.spongepowered.math.vector.Vector3i;

public interface Volume {
    public Vector3i min();

    public Vector3i max();

    default public Vector3i size() {
        return this.max().sub(this.min()).add(Vector3i.ONE);
    }

    default public boolean contains(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.contains(position.x(), position.y(), position.z());
    }

    public boolean contains(int var1, int var2, int var3);

    default public boolean available(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.isAreaAvailable(position.x(), position.y(), position.z());
    }

    public boolean isAreaAvailable(int var1, int var2, int var3);
}

