/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeBlockSnapshot
implements BlockSnapshot,
SpongeImmutableDataHolder<BlockSnapshot>,
DataContainerHolder.Immutable<BlockSnapshot>,
DataCompoundHolder {
    private final org.spongepowered.api.block.BlockState blockState;
    private final ResourceKey worldKey;
    private final Vector3i pos;
    final @Nullable CompoundTag compound;
    private final BlockPos blockPos;
    private final SpongeBlockChangeFlag changeFlag;
    @Nullable WeakReference<ServerLevel> world;
    public @MonotonicNonNull BlockChange blockChange;

    SpongeBlockSnapshot(BuilderImpl builder, boolean copyCompound) {
        this.blockState = Objects.requireNonNull(builder.blockState);
        this.worldKey = Objects.requireNonNull(builder.worldKey);
        this.pos = Objects.requireNonNull(builder.coordinates);
        this.blockPos = VecHelper.toBlockPos(this.pos);
        this.compound = copyCompound ? (builder.compound == null ? null : builder.compound.copy()) : builder.compound;
        this.changeFlag = builder.flag;
        this.world = builder.worldRef;
        builder.worldRef = null;
    }

    SpongeBlockSnapshot() {
        this.blockState = (org.spongepowered.api.block.BlockState)Blocks.AIR.defaultBlockState();
        this.worldKey = Constants.World.INVALID_WORLD_KEY;
        this.pos = Vector3i.ZERO;
        this.blockPos = BlockPos.ZERO;
        this.compound = null;
        this.changeFlag = null;
    }

    @Override
    public org.spongepowered.api.block.BlockState state() {
        return this.blockState;
    }

    public BlockState nativeState() {
        return (BlockState)this.blockState;
    }

    @Override
    public BlockSnapshot withState(org.spongepowered.api.block.BlockState blockState) {
        return this.createBuilder().blockState(blockState).build();
    }

    @Override
    public BlockSnapshot withContainer(DataContainer container) {
        return (BlockSnapshot)BuilderImpl.pooled().build(container).get();
    }

    @Override
    public ResourceKey world() {
        return this.worldKey;
    }

    @Override
    public Vector3i position() {
        return this.pos;
    }

    @Override
    public Optional<ServerLocation> location() {
        return this.getServerWorld().map(world -> ServerLocation.of((ServerWorld)world, this.pos));
    }

    @Override
    public BlockSnapshot withLocation(ServerLocation location) {
        return BuilderImpl.pooled().from(this).position(location.blockPosition()).world(location.worldKey()).build();
    }

    @Override
    public boolean restore(boolean force, BlockChangeFlag flag) {
        Optional<ServerLevel> optionalWorld = this.getServerWorld();
        if (!optionalWorld.isPresent()) {
            return false;
        }
        ServerLevel world = optionalWorld.get();
        try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER);){
            ((PhaseContext)context).buildAndSwitch();
            BlockPos pos = VecHelper.toBlockPos(this.pos);
            if (!world.isInWorldBounds(pos)) {
                boolean bl = false;
                return bl;
            }
            BlockState current = world.getBlockState(pos);
            BlockState replaced = (BlockState)this.blockState;
            if (!(force || current.getBlock() == replaced.getBlock() && current == replaced)) {
                boolean bl = false;
                return bl;
            }
            if (!current.is(((BlockState)this.blockState).getBlock())) {
                world.removeBlockEntity(pos);
            }
            world.setBlock(pos, replaced, BlockChangeFlagManager.andNotifyClients(flag).getRawFlag());
            if (this.compound != null) {
                @Nullable BlockEntity te = world.getBlockEntity(pos);
                if (te != null) {
                    te.setBlockState((BlockState)this.blockState);
                    te.load(this.compound);
                } else {
                    try {
                        te = BlockEntity.loadStatic((BlockPos)pos, (BlockState)((BlockState)this.blockState), (CompoundTag)this.compound);
                        if (te != null) {
                            world.getChunk(pos).setBlockEntity(te);
                        }
                    }
                    catch (Exception e) {
                        PrettyPrinter printer = new PrettyPrinter(60).add("Unable to restore").centre().hr().add("A mod is not correctly deserializing a TileEntity that is being restored. ").addWrapped(60, "Note that this is not the fault of Sponge. Sponge is understanding that a block is supposed to have a TileEntity, but the mod is breaking the contracton how to re-create the tile entity. Please open an issue with the offending mod.", new Object[0]).add("Here's the provided compound:");
                        printer.add();
                        try {
                            printer.addWrapped(80, "%s : %s", "This compound", this.compound);
                        }
                        catch (Throwable error) {
                            printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                        }
                        printer.add().add("Desired World: " + this.worldKey).add("Position: " + this.pos).add("Desired BlockState: " + this.blockState);
                        printer.add();
                        printer.log(SpongeCommon.logger(), Level.ERROR);
                        boolean bl = true;
                        if (context != null) {
                            ((PhaseContext)context).close();
                        }
                        return bl;
                    }
                }
                if (te != null) {
                    te.setChanged();
                }
            }
            world.getChunkSource().blockChanged(pos);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Optional<UUID> creator() {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> notifier() {
        return Optional.empty();
    }

    @Override
    public Optional<BlockEntityArchetype> createArchetype() {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public BlockSnapshot withRawData(DataView container) throws InvalidDataException {
        return BuilderImpl.pooled().buildContent(container).orElseThrow(InvalidDataException::new);
    }

    @Override
    public boolean validateRawData(DataView container) {
        return BuilderImpl.pooled().buildContent(container).isPresent();
    }

    @Override
    public BlockSnapshot copy() {
        return this;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.WORLD_KEY, this.worldKey.asString()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, this.pos.x()).set(Queries.POSITION_Y, this.pos.y()).set(Queries.POSITION_Z, this.pos.z()).container().set(Constants.Block.BLOCK_STATE, this.blockState);
        if (this.compound != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, NBTTranslator.INSTANCE.translateFrom(this.compound));
        }
        return container;
    }

    public Optional<ServerLevel> getServerWorld() {
        ServerLevel world;
        ServerLevel serverLevel = world = this.world != null ? (ServerLevel)this.world.get() : null;
        if (world == null && (world = (ServerLevel)Sponge.server().worldManager().world(this.worldKey).orElse(null)) != null) {
            this.world = new WeakReference<ServerLevel>(world);
        }
        return Optional.ofNullable(world);
    }

    public Optional<CompoundTag> getCompound() {
        return this.compound == null ? Optional.empty() : Optional.of(this.compound.copy());
    }

    public BuilderImpl createBuilder() {
        BuilderImpl builder = BuilderImpl.pooled();
        builder.blockState(this.blockState).position(this.pos);
        Optional<ServerLevel> optionalWorld = this.getServerWorld();
        if (optionalWorld.isPresent()) {
            builder.world(optionalWorld.get());
        } else {
            builder.world(this.worldKey);
        }
        if (this.compound != null) {
            builder.addUnsafeCompound(this.compound);
        }
        return builder;
    }

    @Override
    public DataContainer data$getDataContainer() {
        if (this.compound == null) {
            return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        }
        return NBTTranslator.INSTANCE.translate(this.compound);
    }

    @Override
    public BlockSnapshot data$withDataContainer(DataContainer container) {
        BuilderImpl builder = this.createBuilder();
        builder.compound = NBTTranslator.INSTANCE.translate(container);
        return builder.build();
    }

    @Override
    public CompoundTag data$getCompound() {
        return this.compound == null ? new CompoundTag() : this.compound.copy();
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Arrays.asList(this, this.state(), this.state().type());
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    public SpongeBlockChangeFlag getChangeFlag() {
        return this.changeFlag;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeBlockSnapshot that = (SpongeBlockSnapshot)o;
        return this.blockState.equals(that.blockState) && this.changeFlag == that.changeFlag && Objects.equals(this.worldKey, that.worldKey) && Objects.equals(this.pos, that.pos) && Objects.equals(this.compound, that.compound);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.worldKey, this.pos, this.changeFlag, this.compound);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeBlockSnapshot.class.getSimpleName() + "[", "]").add("world=" + this.worldKey).add("position=" + this.blockPos).add("blockState=" + this.blockState).toString();
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<BlockSnapshot>
    implements BlockSnapshot.Builder {
        private static final Deque<BuilderImpl> pool = new ConcurrentLinkedDeque<BuilderImpl>();
        org.spongepowered.api.block.BlockState blockState;
        ResourceKey worldKey;
        @Nullable UUID creatorUniqueId;
        @Nullable UUID notifierUniqueId;
        Vector3i coordinates;
        @Nullable List<DataManipulator.Immutable> manipulators;
        @Nullable CompoundTag compound;
        SpongeBlockChangeFlag flag = (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
        @Nullable WeakReference<ServerLevel> worldRef;
        private final boolean pooled;

        public static BuilderImpl unpooled() {
            return new BuilderImpl(false);
        }

        public static BuilderImpl pooled() {
            BuilderImpl builder = pool.pollFirst();
            if (builder != null) {
                return builder.reset();
            }
            return new BuilderImpl(true);
        }

        private BuilderImpl(boolean pooled) {
            super(BlockSnapshot.class, 1);
            this.pooled = pooled;
        }

        @Override
        public @NonNull BuilderImpl world(@NonNull ServerWorldProperties worldProperties) {
            this.worldKey = Objects.requireNonNull(worldProperties).key();
            return this;
        }

        public BuilderImpl world(ResourceKey key) {
            this.worldKey = Objects.requireNonNull(key);
            return this;
        }

        public BuilderImpl world(ServerLevel world) {
            this.worldKey = ((ServerWorld)Objects.requireNonNull(world)).key();
            this.worldRef = new WeakReference<ServerLevel>(world);
            return this;
        }

        @Override
        public @NonNull BuilderImpl blockState(@NonNull org.spongepowered.api.block.BlockState blockState) {
            this.blockState = Objects.requireNonNull(blockState);
            return this;
        }

        public BuilderImpl blockState(BlockState blockState) {
            this.blockState = Objects.requireNonNull((org.spongepowered.api.block.BlockState)blockState);
            return this;
        }

        @Override
        public @NonNull BuilderImpl position(@NonNull Vector3i position) {
            this.coordinates = Objects.requireNonNull(position);
            if (this.compound != null) {
                this.compound.putInt("x", position.x());
                this.compound.putInt("y", position.y());
                this.compound.putInt("z", position.z());
            }
            return this;
        }

        @Override
        public @NonNull BlockSnapshot.Builder from(@NonNull ServerLocation location) {
            return this.from(location.createSnapshot());
        }

        @Override
        public @NonNull BuilderImpl creator(UUID uuid) {
            this.creatorUniqueId = Objects.requireNonNull(uuid);
            return this;
        }

        @Override
        public @NonNull BuilderImpl notifier(UUID uuid) {
            this.notifierUniqueId = Objects.requireNonNull(uuid);
            return this;
        }

        @Override
        public <V> @NonNull BlockSnapshot.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.blockState = (org.spongepowered.api.block.BlockState)this.blockState.with(key, value).orElseThrow(() -> new IllegalArgumentException(String.format("Key %s is not supported for block state %s", key.key().asString(), this.blockState.toString())));
            return this;
        }

        @Override
        public @NonNull BuilderImpl from(BlockSnapshot holder) {
            Objects.requireNonNull(holder);
            this.blockState = holder.state();
            this.worldKey = holder.world();
            if (holder.creator().isPresent()) {
                this.creatorUniqueId = holder.creator().get();
            }
            if (holder.notifier().isPresent()) {
                this.notifierUniqueId = holder.notifier().get();
            }
            this.coordinates = holder.position();
            return this;
        }

        @Override
        public BuilderImpl from(SpongeBlockSnapshot snapshot) {
            Objects.requireNonNull(snapshot);
            this.blockState = snapshot.state();
            this.worldKey = snapshot.world();
            this.worldRef = snapshot.world;
            this.compound = snapshot.compound != null ? snapshot.compound.copy() : null;
            this.coordinates = snapshot.position();
            this.flag = snapshot.getChangeFlag();
            return this;
        }

        public org.spongepowered.api.block.BlockState getBlockState() {
            return this.blockState;
        }

        public ResourceKey getWorldKey() {
            return this.worldKey;
        }

        public @Nullable UUID getCreatorUniqueId() {
            return this.creatorUniqueId;
        }

        public Vector3i getCoordinates() {
            return this.coordinates;
        }

        public @Nullable List<DataManipulator.Immutable> getManipulators() {
            return this.manipulators;
        }

        public @Nullable CompoundTag getCompound() {
            return this.compound;
        }

        public SpongeBlockChangeFlag getFlag() {
            return this.flag;
        }

        @Override
        public @NonNull BuilderImpl reset() {
            this.blockState = (org.spongepowered.api.block.BlockState)Blocks.AIR.defaultBlockState();
            this.worldKey = Constants.World.INVALID_WORLD_KEY;
            this.creatorUniqueId = null;
            this.notifierUniqueId = null;
            this.coordinates = null;
            this.manipulators = null;
            this.compound = null;
            this.flag = null;
            return this;
        }

        public @NonNull SpongeBlockSnapshot build() {
            Objects.requireNonNull(this.blockState, "BlockState cannot be null!");
            SpongeBlockSnapshot spongeBlockSnapshot = new SpongeBlockSnapshot(this, !this.pooled);
            this.reset();
            if (this.pooled) {
                pool.push(this);
            }
            return spongeBlockSnapshot;
        }

        @Override
        protected @NonNull Optional<BlockSnapshot> buildContent(DataView container) throws InvalidDataException {
            if (!container.contains(Constants.Block.BLOCK_STATE, Constants.Sponge.SNAPSHOT_WORLD_POSITION)) {
                return Optional.empty();
            }
            if (!container.contains(Queries.WORLD_KEY)) {
                if (!container.contains(Constants.Sponge.BlockSnapshot.WORLD_UUID)) {
                    return Optional.empty();
                }
                UUID uuid = UUID.fromString(container.getString(Constants.Sponge.BlockSnapshot.WORLD_UUID).get());
                Sponge.server().worldManager().worldKey(uuid).ifPresent(worldKey -> container.set(Queries.WORLD_KEY, worldKey));
            }
            DataUtil.checkDataExists(container, Constants.Block.BLOCK_STATE);
            DataUtil.checkDataExists(container, Queries.WORLD_KEY);
            BuilderImpl builder = BuilderImpl.pooled();
            ResourceKey worldKey2 = container.getResourceKey(Queries.WORLD_KEY).get();
            Vector3i coordinate = DataUtil.getPosition3i(container);
            Optional<String> creatorUuid = container.getString(Queries.CREATOR_ID);
            Optional<String> notifierUuid = container.getString(Queries.NOTIFIER_ID);
            org.spongepowered.api.block.BlockState blockState = container.getSerializable(Constants.Block.BLOCK_STATE, org.spongepowered.api.block.BlockState.class).get();
            builder.blockState(blockState).world(worldKey2).position(coordinate);
            creatorUuid.ifPresent(s -> builder.creator(UUID.fromString(s)));
            notifierUuid.ifPresent(s -> builder.notifier(UUID.fromString(s)));
            container.getView(Constants.Sponge.UNSAFE_NBT).map(dataView -> NBTTranslator.INSTANCE.translate((DataView)dataView)).ifPresent(builder::addUnsafeCompound);
            return Optional.of(builder.build());
        }

        public BuilderImpl addUnsafeCompound(CompoundTag compound) {
            Objects.requireNonNull(compound);
            this.compound = compound.copy();
            return this;
        }

        public BuilderImpl flag(BlockChangeFlag flag) {
            this.flag = (SpongeBlockChangeFlag)flag;
            return this;
        }

        public BuilderImpl tileEntity(BlockEntity added) {
            this.compound = added.saveWithFullMetadata();
            return this;
        }
    }

    public static final class FactoryImpl
    implements BlockSnapshot.Factory {
        @Override
        public BlockSnapshot empty() {
            return Holder.EMPTY;
        }

        static final class Holder {
            static final SpongeBlockSnapshot EMPTY = new SpongeBlockSnapshot();

            Holder() {
            }
        }
    }
}

