/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedZeroAdvanceValueParameter;

public final class SpongeTargetBlockValueParameter
extends ResourceKeyedZeroAdvanceValueParameter<ServerLocation> {
    public SpongeTargetBlockValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public @NonNull Optional<? extends ServerLocation> parseValue(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        Object root = cause.cause().root();
        if (root instanceof Living) {
            Living living = (Living)root;
            Optional<RayTraceResult<@NonNull LocatableBlock>> rayTraceResult = RayTrace.block().sourceEyePosition(living).direction(living.headDirection()).limit(30).continueWhileBlock(RayTrace.onlyAir()).select(RayTrace.nonAir()).continueWhileEntity(r -> false).execute();
            if (rayTraceResult.isPresent()) {
                return rayTraceResult.map(x -> ((LocatableBlock)x.selectedObject()).serverLocation());
            }
            throw reader.createException((Component)Component.text((String)"The cause root is not looking at a block!"));
        }
        throw reader.createException((Component)Component.text((String)"The cause root must be a Living!"));
    }
}

