/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.world.server.DataPackManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;
import org.spongepowered.common.datapack.SpongeDataPackType;
import org.spongepowered.common.event.lifecycle.RegisterDataPackValueEventImpl;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;
import org.spongepowered.common.util.FutureUtil;

public final class SpongeDataPackManager
implements DataPackManager {
    private final MinecraftServer server;
    private final Path packsDir;
    private boolean ignoreNext;

    public SpongeDataPackManager(MinecraftServer server, Path packsDir) {
        this.server = server;
        this.packsDir = packsDir;
    }

    public void init() {
        this.ignoreNext = false;
        List<String> reloadablePacks = this.registerPacks();
        if (!reloadablePacks.isEmpty()) {
            SpongeCommon.logger().info("Reloading for plugin data packs... " + reloadablePacks.size());
            this.ignoreNext = true;
            this.server.reloadResources(this.discoverNewPacks());
        }
    }

    private List<String> discoverNewPacks() {
        PackRepository packRepo = this.server.getPackRepository();
        ArrayList<String> toReload = new ArrayList<String>(packRepo.getSelectedIds());
        packRepo.reload();
        List disabled = this.server.getWorldData().getDataConfiguration().dataPacks().getDisabled();
        for (String available : packRepo.getAvailableIds()) {
            if (disabled.contains(available) || toReload.contains(available)) continue;
            toReload.add(available);
        }
        return toReload;
    }

    @Override
    public CompletableFuture<Void> reload() {
        this.ignoreNext = false;
        return this.server.reloadResources(this.discoverNewPacks());
    }

    public List<String> registerPacks() {
        if (this.ignoreNext) {
            this.ignoreNext = false;
            return List.of();
        }
        SpongeIngredient.clearCache();
        IngredientResultUtil.clearCache();
        ArrayList<String> reloadablePacks = new ArrayList<String>();
        this.registerAndSerializePack(DataPackTypes.ADVANCEMENT, reloadablePacks);
        this.registerAndSerializePack(DataPackTypes.RECIPE, reloadablePacks);
        this.registerAndSerializePack(DataPackTypes.BLOCK_TAG, reloadablePacks);
        return reloadablePacks;
    }

    private <T extends DataPackEntry<T>> List<T> callRegisterDataPackValueEvent(SpongeDataPackType<JsonElement, T> type) {
        RegisterDataPackValueEventImpl<T> event = new RegisterDataPackValueEventImpl<T>(Cause.of(EventContext.empty(), SpongeCommon.game()), (Game)SpongeCommon.game(), type);
        SpongeCommon.post(event);
        return event.serializables();
    }

    private <T extends DataPackEntry<T>> void registerAndSerializePack(DataPackType<T> type, Collection<String> reloadablePacks) {
        List<T> packEntries = this.callRegisterDataPackValueEvent((SpongeDataPackType)type);
        if (packEntries.isEmpty()) {
            return;
        }
        this.serializePack(reloadablePacks, packEntries);
    }

    private <T extends DataPackEntry<T>> void serializePack(Collection<String> reloadablePacks, List<T> packEntries) {
        for (DataPackEntry packEntry : packEntries) {
            SpongeDataPack implPack = (SpongeDataPack)packEntry.pack();
            String fullPackName = "file/" + implPack.name();
            try {
                boolean success = ((SpongeDataPackType)implPack.type()).packSerializer().serialize(implPack, this.packDir(implPack), packEntries);
                DataPackSerializer.writePackMetadata(implPack, this.packDir(implPack), false);
                if (success && ((SpongeDataPackType)implPack.type()).reloadable()) {
                    reloadablePacks.add(fullPackName);
                    continue;
                }
                reloadablePacks.remove(fullPackName);
            }
            catch (IOException e) {
                reloadablePacks.remove(fullPackName);
                SpongeCommon.logger().error((Object)e);
            }
        }
    }

    @Override
    public <T extends DataPackEntry<T>> CompletableFuture<Boolean> save(T entry) {
        if (entry.pack().name().equals("Default")) {
            return CompletableFuture.completedFuture(false);
        }
        this.serializePack(new ArrayList<String>(), List.of(entry));
        return CompletableFuture.completedFuture(((SpongeDataPackType)entry.pack().type()).reloadable());
    }

    @Override
    public <T extends DataPackEntry<T>> CompletableFuture<Optional<T>> load(DataPack<T> pack, ResourceKey key) {
        Objects.requireNonNull(key, "key");
        SpongeDataPack implPack = (SpongeDataPack)pack;
        ResourceManager manager = this.server.getResourceManager();
        DataPackSerializer packSerializer = ((SpongeDataPackType)implPack.type()).packSerializer();
        Optional resource = manager.getResource(packSerializer.location(implPack.type(), key));
        if (resource.isPresent()) {
            CompletableFuture completableFuture;
            block12: {
                InputStream inputStream = ((Resource)resource.get()).open();
                try {
                    Object deserialized = packSerializer.deserialize(implPack, inputStream, key);
                    completableFuture = CompletableFuture.completedFuture(Optional.ofNullable(deserialized));
                    if (inputStream == null) break block12;
                }
                catch (Throwable deserialized) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                deserialized.addSuppressed(throwable);
                            }
                        }
                        throw deserialized;
                    }
                    catch (IOException ex) {
                        return FutureUtil.completedWithException(ex);
                    }
                }
                inputStream.close();
            }
            return completableFuture;
        }
        Path file = this.packFile(implPack, key);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Object deserialized = packSerializer.deserialize(implPack, file, key);
                return CompletableFuture.completedFuture(Optional.ofNullable(deserialized));
            }
            catch (IOException ex) {
                return FutureUtil.completedWithException(ex);
            }
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public boolean exists(DataPack<?> pack, ResourceKey key) {
        SpongeDataPack packImpl = (SpongeDataPack)pack;
        Path file = this.packFile(packImpl, Objects.requireNonNull(key, "key"));
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public boolean delete(DataPack<?> pack, ResourceKey key) throws IOException {
        SpongeDataPack packImpl = (SpongeDataPack)pack;
        Path file = this.packFile(packImpl, Objects.requireNonNull(key, "key"));
        return Files.deleteIfExists(file);
    }

    @Override
    public void copy(DataPack<?> pack, ResourceKey from, ResourceKey to) throws IOException {
        this.copy(pack, from, pack, to);
    }

    @Override
    public void copy(DataPack<?> fromPack, ResourceKey from, DataPack<?> toPack, ResourceKey to) throws IOException {
        SpongeDataPack packImpl = (SpongeDataPack)fromPack;
        SpongeDataPack packImplTo = (SpongeDataPack)toPack;
        Path fileFrom = this.packFile(packImpl, Objects.requireNonNull(from, "from"));
        Path fileto = this.packFile(packImplTo, Objects.requireNonNull(to, "to"));
        Files.createDirectories(fileto.getParent(), new FileAttribute[0]);
        Files.copy(fileFrom, fileto, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void move(DataPack<?> pack, ResourceKey from, ResourceKey to) throws IOException {
        this.move(pack, from, pack, to);
    }

    @Override
    public void move(DataPack<?> fromPack, ResourceKey from, DataPack<?> toPack, ResourceKey to) throws IOException {
        SpongeDataPack packImpl = (SpongeDataPack)fromPack;
        SpongeDataPack packImplTo = (SpongeDataPack)toPack;
        Path fileFrom = this.packFile(packImpl, Objects.requireNonNull(from, "from"));
        Path fileto = this.packFile(packImplTo, Objects.requireNonNull(to, "to"));
        Files.createDirectories(fileto.getParent(), new FileAttribute[0]);
        Files.copy(fileFrom, fileto, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public List<ResourceKey> list(DataPack<?> pack) {
        ArrayList<ResourceKey> packEntries = new ArrayList<ResourceKey>();
        Path packDir = this.packDir(pack);
        if (!Files.isDirectory(packDir, new LinkOption[0])) {
            return packEntries;
        }
        try (Stream<Path> namespaces = Files.walk(packDir.resolve("data"), 1, new FileVisitOption[0]);){
            namespaces.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(namespaceDir -> {
                Path typeDir = namespaceDir.resolve(((SpongeDataPackType)((SpongeDataPack)pack).type()).dir());
                if (Files.isDirectory(typeDir, new LinkOption[0])) {
                    try (Stream<Path> pluginTemplates = Files.walk(typeDir, 1, new FileVisitOption[0]);){
                        pluginTemplates.filter(file -> file.toString().endsWith(".json")).map(file -> SpongeDataPackManager.keyFor(namespaceDir, file)).forEach(packEntries::add);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packEntries;
    }

    @Override
    public <T extends DataPackEntry<T>> Map<DataPack<T>, Collection<ResourceKey>> find(DataPackType<T> packType) {
        ResourceManager manager = this.server.getResourceManager();
        HashMap resources = new HashMap();
        HashMap descriptions = new HashMap();
        SpongeDataPackType typeImpl = (SpongeDataPackType)packType;
        manager.listPacks().forEach(pack -> {
            String packName = pack.packId();
            descriptions.computeIfAbsent(packName, k -> this.packDescription((PackResources)pack));
            for (String namespace : pack.getNamespaces(PackType.SERVER_DATA)) {
                HashSet locs = new HashSet();
                pack.listResources(PackType.SERVER_DATA, namespace, typeImpl.dir(), (loc, stream) -> locs.add(loc));
                if (locs.isEmpty()) continue;
                resources.computeIfAbsent(packName, k -> new ArrayList()).addAll(locs);
            }
        });
        HashMap<DataPack<T>, Collection<ResourceKey>> map = new HashMap<DataPack<T>, Collection<ResourceKey>>();
        for (Map.Entry entry : resources.entrySet()) {
            map.put(packType.pack((String)entry.getKey(), (String)descriptions.get(entry.getKey())), ((List)entry.getValue()).stream().map(loc -> {
                String path = loc.getPath();
                String value = path.substring(typeImpl.dir().length() + 1, path.length() - typeImpl.packSerializer().fileEnding().length());
                return ResourceKey.of(loc.getNamespace(), value);
            }).toList());
        }
        return map;
    }

    @Override
    public <T extends DataPackEntry<T>> Optional<DataPack<T>> findPack(DataPackType<T> packType, ResourceKey key) {
        SpongeDataPackType implType = (SpongeDataPackType)packType;
        ResourceLocation compareLoc = implType.packSerializer().location(implType, key);
        Iterator iterator = this.server.getResourceManager().listResources(((SpongeDataPackType)packType).dir(), loc -> loc.equals((Object)compareLoc)).values().iterator();
        if (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            return Optional.of(packType.pack(resource.sourcePackId(), "N/A"));
        }
        return Optional.empty();
    }

    private String packDescription(PackResources pack) {
        try {
            return ((PackMetadataSection)pack.getMetadataSection((MetadataSectionSerializer)PackMetadataSection.TYPE)).getDescription().getString();
        }
        catch (IOException e) {
            return "N/A";
        }
    }

    private static ResourceKey keyFor(Path namespaceDir, Path file) {
        String namespace = namespaceDir.getFileName().toString();
        String value = FilenameUtils.removeExtension((String)file.getFileName().toString());
        return ResourceKey.of(namespace, value);
    }

    private <T extends DataPackEntry<T>> Path packFile(SpongeDataPack<?, T> pack, ResourceKey key) {
        return ((SpongeDataPackType)pack.type()).packSerializer().packEntryFile(pack.type(), key, this.packDir(pack));
    }

    private Path packDir(DataPack<?> pack) {
        return this.packsDir.resolve(pack.name());
    }
}

