/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.common.accessor.world.level.chunk.ChunkAccessAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateHeightMapEffect
implements ProcessingSideEffect {
    UpdateHeightMapEffect() {
    }

    public static UpdateHeightMapEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        Map<Heightmap.Types, Heightmap> heightMap = ((ChunkAccessAccessor)pipeline.getAffectedChunk()).accessor$heightmaps();
        if (heightMap == null) {
            throw new IllegalStateException("Heightmap dereferenced!");
        }
        int x = oldState.pos.getX() & 0xF;
        int y = oldState.pos.getY();
        int z = oldState.pos.getZ() & 0xF;
        heightMap.get(Heightmap.Types.MOTION_BLOCKING).update(x, y, z, newState);
        heightMap.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).update(x, y, z, newState);
        heightMap.get(Heightmap.Types.OCEAN_FLOOR).update(x, y, z, newState);
        heightMap.get(Heightmap.Types.WORLD_SURFACE).update(x, y, z, newState);
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateHeightMapEffect INSTANCE = new UpdateHeightMapEffect();

        private Holder() {
        }
    }
}

