/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeFurnaceRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;

public abstract class SpongeCookingRecipeSerializer<R extends AbstractCookingRecipe>
implements RecipeSerializer<R> {
    private final int defaultCookingTime;

    public SpongeCookingRecipeSerializer(int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
    }

    public R fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
        CookingBookCategory category = Objects.requireNonNullElse((CookingBookCategory)CookingBookCategory.CODEC.byName(GsonHelper.getAsString((JsonObject)json, (String)"category", null)), CookingBookCategory.MISC);
        JsonElement jsonelement = GsonHelper.isArrayNode((JsonObject)json, (String)"ingredient") ? GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredient") : GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = IngredientUtil.spongeDeserialize(jsonelement);
        String result = GsonHelper.getAsString((JsonObject)json, (String)"result");
        ResourceLocation resourcelocation = new ResourceLocation(result);
        ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        Function<Container, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        float exp = GsonHelper.getAsFloat((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = GsonHelper.getAsInt((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.create(recipeId, group, category, ingredient, spongeStack == null ? itemstack : spongeStack, exp, cookTime, resultFunction);
    }

    protected abstract R create(ResourceLocation var1, String var2, CookingBookCategory var3, Ingredient var4, ItemStack var5, float var6, int var7, Function<Container, ItemStack> var8);

    public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(FriendlyByteBuf buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public static class Campfire
    extends SpongeCookingRecipeSerializer<CampfireCookingRecipe> {
        public Campfire() {
            super(100);
        }

        @Override
        protected CampfireCookingRecipe create(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<Container, ItemStack> resultFunction) {
            return new SpongeCampfireCookingRecipe(id, group, category, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Smoking
    extends SpongeCookingRecipeSerializer<SmokingRecipe> {
        public Smoking() {
            super(100);
        }

        @Override
        protected SmokingRecipe create(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<Container, ItemStack> resultFunction) {
            return new SpongeSmokingRecipe(id, group, category, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Blasting
    extends SpongeCookingRecipeSerializer<BlastingRecipe> {
        public Blasting() {
            super(100);
        }

        @Override
        protected BlastingRecipe create(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<Container, ItemStack> resultFunction) {
            return new SpongeBlastingRecipe(id, group, category, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Smelting
    extends SpongeCookingRecipeSerializer<SmeltingRecipe> {
        public Smelting() {
            super(200);
        }

        @Override
        protected SmeltingRecipe create(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<Container, ItemStack> resultFunction) {
            return new SpongeFurnaceRecipe(id, group, category, ingredient, result, experience, cookingTime, resultFunction);
        }
    }
}

