/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.util;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackComparators;
import org.spongepowered.api.registry.RegistryTypes;

public class SpongeItemStackComparatorFactory
implements ItemStackComparators.Factory {
    private Comparator<ItemStack> comparator;

    public SpongeItemStackComparatorFactory() {
    }

    public SpongeItemStackComparatorFactory(Comparator<ItemStack> comparator) {
        this.comparator = comparator;
    }

    @Override
    public ItemStackComparators.Factory byType() {
        Comparator<ItemStack> comparator = Comparator.comparing(i -> i.type().key(RegistryTypes.ITEM_TYPE));
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    @Override
    public ItemStackComparators.Factory byData() {
        ItemDataComparator comparator = new ItemDataComparator(new Key[0]);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    @Override
    public ItemStackComparators.Factory byDurability() {
        ItemDataComparator comparator = new ItemDataComparator(new Key[0]);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    @Override
    public ItemStackComparators.Factory bySize() {
        Comparator<ItemStack> comparator = Comparator.comparing(ItemStack::quantity);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(this.comparator));
    }

    @Override
    public Supplier<Comparator<ItemStack>> asSupplier() {
        Comparator<ItemStack> comparator = this.build();
        return () -> comparator;
    }

    @Override
    public Comparator<ItemStack> build() {
        return this.comparator;
    }

    private static final class ItemDataComparator
    implements Comparator<ItemStack> {
        private final Key<? extends Value<?>>[] ignored;

        ItemDataComparator(Key<? extends Value<?>> ... ignored) {
            this.ignored = ignored;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            HashSet values = new HashSet(o2.getValues());
            for (Value.Immutable<?> value : o1.getValues()) {
                if (values.contains(value)) {
                    values.remove(value);
                    continue;
                }
                if (this.isIgnored(values, value)) continue;
                return -1;
            }
            return values.size();
        }

        private boolean isIgnored(Set<Value.Immutable<?>> list, Value.Immutable<?> toCheck) {
            for (Key<? extends Value<?>> ignore : this.ignored) {
                if (!toCheck.key().equals(ignore)) continue;
                list.removeIf(val -> ignore.equals(val.key()));
                return true;
            }
            return false;
        }
    }
}

