/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.core.RegistryBridge;
import org.spongepowered.common.bridge.core.WritableRegistryBridge;

@Mixin(value={MappedRegistry.class})
@Implements(value={@Interface(iface=Registry.class, prefix="registry$", remap=Interface.Remap.NONE)})
public abstract class MappedRegistryMixin_API<T>
implements Registry<T> {
    @Shadow
    public abstract Holder.Reference<T> shadow$register(ResourceKey<T> var1, T var2, Lifecycle var3);

    @Shadow
    public abstract ResourceKey<? extends net.minecraft.core.Registry<T>> shadow$key();

    private ResourceLocation impl$getKey(T value) {
        return ((net.minecraft.core.Registry)this).getKey(value);
    }

    private Optional<T> impl$getOptional(@Nullable ResourceLocation param0) {
        return ((net.minecraft.core.Registry)this).getOptional(param0);
    }

    private Optional<HolderSet.Named<T>> impl$getTag(TagKey<T> var1) {
        return ((net.minecraft.core.Registry)this).getTag(var1);
    }

    private Stream<TagKey<T>> impl$getTagNames() {
        return ((net.minecraft.core.Registry)this).getTagNames();
    }

    @Override
    public RegistryType<T> type() {
        return ((RegistryBridge)((Object)this)).bridge$type();
    }

    @Override
    public org.spongepowered.api.ResourceKey valueKey(T value) {
        Objects.requireNonNull(value, "value");
        ResourceLocation key = this.impl$getKey(value);
        if (key == null) {
            throw new IllegalStateException(String.format("No key was found for '%s'!", value));
        }
        return (org.spongepowered.api.ResourceKey)key;
    }

    @Override
    public Optional<org.spongepowered.api.ResourceKey> findValueKey(T value) {
        Objects.requireNonNull(value, "value");
        return Optional.ofNullable(this.impl$getKey(value)).map(l -> (org.spongepowered.api.ResourceKey)l);
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> findEntry(org.spongepowered.api.ResourceKey key) {
        return ((RegistryBridge)((Object)this)).bridge$get(Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> Optional<V> findValue(org.spongepowered.api.ResourceKey key) {
        return this.impl$getOptional((ResourceLocation)Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> V value(org.spongepowered.api.ResourceKey key) {
        return (V)this.impl$getOptional((ResourceLocation)Objects.requireNonNull(key, "key")).orElseThrow(() -> new ValueNotFoundException(String.format("No value was found for key '%s'!", key)));
    }

    @Override
    public <V extends T> Set<V> taggedValues(Tag<T> tag) {
        return this.impl$getTag((TagKey)tag).stream().flatMap(HolderSet.ListBacked::stream).map(h -> h.value()).collect(Collectors.toSet());
    }

    @Override
    public <V extends T> Stream<Tag<V>> tags() {
        return this.impl$getTagNames().map(Tag.class::cast);
    }

    @Override
    public Stream<RegistryEntry<T>> streamEntries() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries();
    }

    @Intrinsic
    public Stream<T> registry$stream() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries().map(RegistryEntry::value);
    }

    @Override
    public boolean isDynamic() {
        MappedRegistryMixin_API mappedRegistryMixin_API = this;
        if (mappedRegistryMixin_API instanceof WritableRegistryBridge) {
            WritableRegistryBridge bridge = (WritableRegistryBridge)((Object)mappedRegistryMixin_API);
            return bridge.bridge$isDynamic();
        }
        return false;
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> register(org.spongepowered.api.ResourceKey key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.isDynamic()) {
            ResourceKey mcKey = ResourceKey.create(this.shadow$key(), (ResourceLocation)((ResourceLocation)key));
            this.shadow$register(mcKey, value, Lifecycle.stable());
            return ((RegistryBridge)((Object)this)).bridge$get(key);
        }
        return Optional.empty();
    }
}

