/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateProperty;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.util.AxisUtil;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.common.util.PortionTypeUtil;

@Mixin(value={StateHolder.class})
public abstract class StateHolderMixin_API<S extends State<S>, C>
implements State<S>,
SpongeImmutableDataHolder<S> {
    @Shadow
    public abstract <V extends Comparable<V>> boolean shadow$hasProperty(Property<V> var1);

    @Shadow
    public abstract <T extends Comparable<T>> T shadow$getValue(Property<T> var1);

    @Shadow
    public abstract <T extends Comparable<T>, V extends T> C shadow$setValue(Property<T> var1, V var2);

    @Shadow
    public abstract <T extends Comparable<T>> C shadow$cycle(Property<T> var1);

    @Shadow
    public abstract ImmutableMap<Property<?>, Comparable<?>> shadow$getValues();

    private <ApiT extends Comparable<ApiT>, T extends Comparable<?>> ApiT api$mapToApi(T value) {
        if (value instanceof Direction.Axis) {
            Direction.Axis axis = (Direction.Axis)value;
            return (ApiT)AxisUtil.getFor(axis);
        }
        if (value instanceof net.minecraft.core.Direction) {
            net.minecraft.core.Direction dir = (net.minecraft.core.Direction)value;
            return (ApiT)((Object)DirectionUtil.getFor(dir));
        }
        if (value instanceof BedPart) {
            BedPart bedPart = (BedPart)value;
            return (ApiT)PortionTypeUtil.getFor(bedPart);
        }
        if (value instanceof DoubleBlockHalf) {
            DoubleBlockHalf half = (DoubleBlockHalf)value;
            return (ApiT)PortionTypeUtil.getFor(half);
        }
        return (ApiT)value;
    }

    private <ApiT extends Comparable<ApiT>, T extends Comparable<T>, V extends T> V api$mapFromApi(StateProperty<ApiT> stateProperty, ApiT value) {
        if (value instanceof Axis) {
            Axis axis = (Axis)((Object)value);
            return (V)AxisUtil.getFor(axis);
        }
        if (value instanceof Direction) {
            Direction dir = (Direction)((Object)value);
            net.minecraft.core.Direction mappedValue = DirectionUtil.getFor(dir);
            if (mappedValue == null) {
                throw new UnsupportedOperationException("Unsupported Direction " + dir);
            }
            return (V)mappedValue;
        }
        if (value instanceof PortionType) {
            PortionType portion = (PortionType)value;
            Object mappedValue = stateProperty.equals(BlockStateProperties.BED_PART) ? PortionTypeUtil.getBedPartFor(portion) : (stateProperty.equals(BlockStateProperties.DOUBLE_BLOCK_HALF) ? PortionTypeUtil.getDoubleBlockHalfFor(portion) : (stateProperty.equals(BlockStateProperties.HALF) ? PortionTypeUtil.getHalfFor(portion) : null));
            if (mappedValue == null) {
                throw new UnsupportedOperationException("Unsupported Portion " + portion + " for " + this);
            }
            return (V)mappedValue;
        }
        return (V)value;
    }

    @Override
    public <T extends Comparable<T>> Optional<T> stateProperty(StateProperty<T> stateProperty) {
        if (!this.shadow$hasProperty((Property)stateProperty)) {
            return Optional.empty();
        }
        T value = this.shadow$getValue((Property)stateProperty);
        return Optional.of(this.api$mapToApi(value));
    }

    @Override
    public Optional<StateProperty<?>> findStateProperty(String name) {
        return this.stateProperties().stream().filter(p -> p.name().equals(name)).findFirst();
    }

    @Override
    public <T extends Comparable<T>, V extends T> Optional<S> withStateProperty(StateProperty<T> stateProperty, V value) {
        if (!this.shadow$hasProperty((Property)stateProperty)) {
            return Optional.empty();
        }
        return Optional.of((State)this.shadow$setValue((Property)stateProperty, this.api$mapFromApi((StateProperty)stateProperty, (Comparable)value)));
    }

    @Override
    public <T extends Comparable<T>> Optional<S> cycleStateProperty(StateProperty<T> stateProperty) {
        if (!this.shadow$hasProperty((Property)stateProperty)) {
            return Optional.empty();
        }
        return Optional.of((State)this.shadow$cycle((Property)stateProperty));
    }

    @Override
    public <T extends Cycleable<T>> Optional<S> cycleValue(Key<? extends Value<T>> key) {
        Optional optionalValue = this.get(key);
        if (optionalValue.isPresent() && optionalValue.get() instanceof Cycleable) {
            Object next = ((Cycleable)optionalValue.get()).cycleNext();
            return this.with(key, next);
        }
        return Optional.empty();
    }

    @Override
    public Collection<StateProperty<?>> stateProperties() {
        return this.shadow$getValues().keySet();
    }

    @Override
    public Collection<?> statePropertyValues() {
        return this.shadow$getValues().values().stream().map(this::api$mapToApi).toList();
    }

    @Override
    public Map<StateProperty<?>, ?> statePropertyMap() {
        return this.shadow$getValues().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.api$mapToApi((Comparable)e.getValue())));
    }
}

