/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    @Mutable
    private Consumer<Packet<?>> broadcast;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$wrapConsumer(ServerLevel serverLevel, Entity entity, int trackingRange, boolean trackMovementDeltas, Consumer<Packet<?>> broadcaster, CallbackInfo ci) {
        this.broadcast = packet -> {
            if (this.entity instanceof VanishableBridge && !((VanishableBridge)this.entity).bridge$vanishState().invisible()) {
                broadcaster.accept((Packet<?>)packet);
            }
        };
    }

    @Inject(method={"removePairing"}, at={@At(value="RETURN")})
    private void impl$removeHumanFromPlayerClient(ServerPlayer viewer, CallbackInfo ci) {
        if (this.entity instanceof HumanEntity) {
            ((HumanEntity)this.entity).untrackFrom(viewer);
        }
    }

    @Redirect(method={"sendPairingData"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", ordinal=0))
    public void impl$sendHumanSpawnPacket(Consumer<Packet<?>> consumer, Object spawnPacket) {
        Entity entity = this.entity;
        if (!(entity instanceof HumanEntity)) {
            consumer.accept((Packet)spawnPacket);
            return;
        }
        HumanEntity human = (HumanEntity)entity;
        consumer.accept((Packet<?>)human.getAddEntityPacket());
        consumer.accept((Packet)spawnPacket);
        ClientboundPlayerInfoRemovePacket removePacket = new ClientboundPlayerInfoRemovePacket(List.of(human.getUUID()));
        if (human.canRemoveFromListImmediately()) {
            consumer.accept((Packet<?>)removePacket);
        } else {
            human.removeFromTabListDelayed(null, removePacket);
        }
    }

    @Inject(method={"sendDirtyEntityData"}, at={@At(value="HEAD")})
    public void impl$sendHumanMetadata(CallbackInfo ci) {
        Entity entity = this.entity;
        if (!(entity instanceof HumanEntity)) {
            return;
        }
        HumanEntity human = (HumanEntity)entity;
        Stream<Packet<?>> packets = human.popQueuedPackets(null);
        packets.forEach(this.broadcast);
    }

    @ModifyArg(method={"sendDirtyEntityData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundUpdateAttributesPacket;<init>(ILjava/util/Collection;)V"))
    private Collection<AttributeInstance> impl$injectScaledHealth(Collection<AttributeInstance> set) {
        if (this.entity instanceof ServerPlayer && ((ServerPlayerBridge)this.entity).bridge$isHealthScaled()) {
            ((ServerPlayerBridge)this.entity).bridge$injectScaledHealth(set);
        }
        return set;
    }

    @Redirect(method={"sendDirtyEntityData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;packDirty()Ljava/util/List;"))
    private List<SynchedEntityData.DataValue<?>> impl$createSpoofedPacket(SynchedEntityData entityData) {
        if (!(this.entity instanceof ServerPlayerBridge) || !((ServerPlayerBridge)this.entity).bridge$isHealthScaled()) {
            return entityData.packDirty();
        }
        float scaledHealth = ((ServerPlayerBridge)this.entity).bridge$getInternalScaledHealth();
        Float actualHealth = (Float)entityData.get(LivingEntityAccessor.accessor$DATA_HEALTH_ID());
        entityData.set(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)Float.valueOf(scaledHealth));
        List packed = entityData.packDirty();
        entityData.set(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)actualHealth);
        return packed;
    }
}

