/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerEntityHealthScaleBridge;
import org.spongepowered.common.mixin.core.world.entity.player.PlayerMixin;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_HealthScale
extends PlayerMixin
implements ServerPlayerEntityHealthScaleBridge {
    @Shadow
    private float lastSentHealth;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    private double impl$healthScale = 20.0;
    private float impl$cachedModifiedHealth = -1.0f;

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getArmorValue()I", ordinal=1)})
    private void updateHealthPriorToArmor(CallbackInfo ci) {
        this.bridge$refreshScaledHealth();
    }

    @Redirect(method={"doTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getHealth()F"))
    public float impl$onGetHealth(ServerPlayer serverPlayerEntity) {
        return this.bridge$getInternalScaledHealth();
    }

    @Override
    public boolean bridge$setHealthScale(double scale) {
        if (scale < 1.0 || scale > 3.4028234663852886E38) {
            return false;
        }
        this.impl$healthScale = scale;
        this.impl$cachedModifiedHealth = -1.0f;
        this.lastSentHealth = -1.0f;
        ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.HEALTH_SCALE, scale);
        this.bridge$refreshScaledHealth();
        return true;
    }

    @Override
    public void bridge$resetHealthScale() {
        this.impl$healthScale = 20.0;
        this.impl$cachedModifiedHealth = -1.0f;
        this.lastSentHealth = -1.0f;
        ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.HEALTH_SCALE);
        this.bridge$refreshScaledHealth();
    }

    @Override
    public void bridge$refreshScaledHealth() {
        Set dirtyInstances = this.shadow$getAttributes().getDirtyAttributes();
        this.bridge$injectScaledHealth(dirtyInstances);
        FoodData foodData = this.shadow$getFoodData();
        this.connection.send((Packet)new ClientboundSetHealthPacket(this.bridge$getInternalScaledHealth(), foodData.getFoodLevel(), foodData.getSaturationLevel()));
        this.connection.send((Packet)new ClientboundUpdateAttributesPacket(this.shadow$getId(), (Collection)dirtyInstances));
        dirtyInstances.clear();
    }

    @Override
    public void bridge$injectScaledHealth(Collection<AttributeInstance> set) {
        @Nullable Set modifiers = null;
        boolean foundMax = false;
        Iterator<AttributeInstance> iter = set.iterator();
        while (iter.hasNext()) {
            AttributeInstance dirtyInstance = iter.next();
            if (!"attribute.name.generic.maxHealth".equals(dirtyInstance.getAttribute().getDescriptionId())) continue;
            foundMax = true;
            modifiers = dirtyInstance.getModifiers();
            iter.remove();
            break;
        }
        if (!foundMax) {
            modifiers = this.shadow$getAttribute(Attributes.MAX_HEALTH).getModifiers();
        }
        AttributeInstance attribute = new AttributeInstance(Attributes.MAX_HEALTH, i -> {});
        if (this.bridge$isHealthScaled()) {
            attribute.setBaseValue(this.impl$healthScale);
        }
        if (!modifiers.isEmpty()) {
            modifiers.forEach(arg_0 -> ((AttributeInstance)attribute).addTransientModifier(arg_0));
        }
        set.add(attribute);
    }

    @Override
    public double bridge$getHealthScale() {
        return this.impl$healthScale;
    }

    @Override
    public float bridge$getInternalScaledHealth() {
        if (!this.bridge$isHealthScaled()) {
            return this.shadow$getHealth();
        }
        if (this.impl$cachedModifiedHealth == -1.0f) {
            AttributeInstance maxAttribute = this.shadow$getAttribute(Attributes.MAX_HEALTH);
            double modifiedScale = this.impl$healthScale;
            for (AttributeModifier modifier : maxAttribute.getModifiers(AttributeModifier.Operation.ADDITION)) {
                modifiedScale += modifier.getAmount();
            }
            for (AttributeModifier modifier : maxAttribute.getModifiers(AttributeModifier.Operation.MULTIPLY_BASE)) {
                modifiedScale += modifiedScale * modifier.getAmount();
            }
            for (AttributeModifier modifier : maxAttribute.getModifiers(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                modifiedScale *= 1.0 + modifier.getAmount();
            }
            this.impl$cachedModifiedHealth = (float)modifiedScale;
        }
        return this.shadow$getHealth() / this.shadow$getMaxHealth() * this.impl$cachedModifiedHealth;
    }

    @Override
    public boolean bridge$isHealthScaled() {
        return this.impl$healthScale != 20.0;
    }
}

