/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.monster;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.spongepowered.api.entity.living.monster.Creeper;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.world.entity.monster.MonsterMixin;

@Mixin(value={net.minecraft.world.entity.monster.Creeper.class})
public abstract class CreeperMixin
extends MonsterMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int swell;
    @Shadow
    private int maxSwell;
    @Shadow
    private int explosionRadius;
    private int impl$fuseDuration = 30;
    private boolean impl$interactPrimeCancelled;
    private boolean impl$stateDirty;
    private boolean impl$detonationCancelled;

    @Shadow
    public abstract void shadow$ignite();

    @Shadow
    public abstract int shadow$getSwellDir();

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.explosionRadius = radius == null ? 3 : radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.impl$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.impl$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.maxSwell - this.swell;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.swell = 0;
        this.maxSwell = fuseTicks;
    }

    @Inject(method={"setSwellDir"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$preStateChange(int state, CallbackInfo ci) {
        boolean isPrimed;
        if (this.level.isClientSide) {
            return;
        }
        this.bridge$setFuseDuration(this.impl$fuseDuration);
        boolean bl = isPrimed = this.shadow$getSwellDir() == 1;
        if (!isPrimed && state == 1 && !this.bridge$shouldPrime()) {
            ci.cancel();
        } else if (isPrimed && state == -1 && !this.bridge$shouldDefuse()) {
            ci.cancel();
        } else if (this.shadow$getSwellDir() != state) {
            this.impl$stateDirty = true;
        }
    }

    @Inject(method={"setSwellDir"}, at={@At(value="RETURN")})
    private void impl$postStateChange(int state, CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.impl$stateDirty) {
            if (state == 1) {
                this.bridge$postPrime();
            } else if (state == -1) {
                this.bridge$postDefuse();
            }
            this.impl$stateDirty = false;
        }
    }

    @Redirect(method={"explodeCreeper"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;"))
    @Nullable
    private Explosion impl$useSpongeExplosion(Level world, Entity self, double x, double y, double z, float strength, Level.ExplosionInteraction mode) {
        return SpongeCommonEventFactory.detonateExplosive(this, org.spongepowered.api.world.explosion.Explosion.builder().location(ServerLocation.of((ServerWorld)world, x, y, z)).sourceExplosive((Creeper)((Object)this)).radius(strength).shouldPlaySmoke(mode != Level.ExplosionInteraction.NONE).shouldBreakBlocks(mode != Level.ExplosionInteraction.NONE && ((GrieferBridge)((Object)this)).bridge$canGrief())).orElseGet(() -> {
            this.impl$detonationCancelled = true;
            return null;
        });
    }

    @Inject(method={"explodeCreeper"}, at={@At(value="RETURN")})
    private void impl$postExplode(CallbackInfo ci) {
        if (this.impl$detonationCancelled) {
            this.dead = false;
            this.impl$detonationCancelled = false;
        }
    }

    @Redirect(method={"mobInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Creeper;ignite()V"))
    private void impl$onProcessIgnition(net.minecraft.world.entity.monster.Creeper self) {
        boolean bl = this.impl$interactPrimeCancelled = !this.bridge$shouldPrime();
        if (!this.impl$interactPrimeCancelled) {
            this.shadow$ignite();
        }
    }

    @Redirect(method={"mobInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"))
    private void impl$onDamageFlintAndSteel(ItemStack fas, int amount, LivingEntity player, Consumer<LivingEntity> onBroken) {
        if (!this.impl$interactPrimeCancelled) {
            fas.hurtAndBreak(amount, player, onBroken);
        }
        this.impl$interactPrimeCancelled = false;
    }
}

