/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.dimension;

import com.mojang.serialization.Codec;
import net.kyori.adventure.text.Component;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.dimension.LevelStem;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={LevelStem.class})
public abstract class LevelStemMixin
implements LevelStemBridge,
SpongeDataHolder {
    @Shadow
    @Final
    @Mutable
    public static Codec<LevelStem> CODEC;
    private @Nullable GameType impl$gameMode;
    private @Nullable Difficulty impl$difficulty;
    private @Nullable SerializationBehavior impl$serializationBehavior = null;
    private @Nullable Component impl$displayName = null;
    private Integer impl$viewDistance = null;
    private @Nullable Vector3i impl$spawnPosition;
    private @Nullable Boolean impl$hardcore;
    private @Nullable Boolean impl$pvp;
    private @Nullable Boolean impl$commands;
    private @Nullable Long impl$seed;
    private boolean impl$loadOnStartup = true;
    private boolean impl$performsSpawnLogic = false;

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void impl$useTemplateCodec(CallbackInfo ci) {
        CODEC = SpongeWorldTemplate.DIRECT_CODEC;
    }

    @Override
    public Component bridge$displayName() {
        return this.impl$displayName;
    }

    @Override
    public GameType bridge$gameMode() {
        return this.impl$gameMode;
    }

    @Override
    public Difficulty bridge$difficulty() {
        return this.impl$difficulty;
    }

    @Override
    public SerializationBehavior bridge$serializationBehavior() {
        return this.impl$serializationBehavior;
    }

    @Override
    public Integer bridge$viewDistance() {
        return this.impl$viewDistance;
    }

    @Override
    public @Nullable Vector3i bridge$spawnPosition() {
        return this.impl$spawnPosition;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public @Nullable Boolean bridge$hardcore() {
        return this.impl$hardcore;
    }

    @Override
    public @Nullable Boolean bridge$commands() {
        return this.impl$commands;
    }

    @Override
    public @Nullable Boolean bridge$pvp() {
        return this.impl$pvp;
    }

    @Override
    public @Nullable Long bridge$seed() {
        return this.impl$seed;
    }

    @Override
    public LevelStem bridge$decorateData(SpongeWorldTemplate.SpongeDataSection data) {
        this.impl$gameMode = data.gameMode();
        this.impl$difficulty = data.difficulty();
        this.impl$serializationBehavior = data.serializationBehavior();
        this.impl$displayName = data.displayName();
        this.impl$viewDistance = data.viewDistance();
        this.impl$spawnPosition = data.spawnPosition();
        this.impl$loadOnStartup = data.loadOnStartup() == null || data.loadOnStartup() != false;
        this.impl$performsSpawnLogic = data.performsSpawnLogic() != null && data.performsSpawnLogic() != false;
        this.impl$hardcore = data.hardcore();
        this.impl$commands = data.commands();
        this.impl$pvp = data.pvp();
        this.impl$seed = data.seed();
        return (LevelStem)this;
    }

    @Override
    public LevelStem bridge$decorateData(DataManipulator data) {
        this.impl$gameMode = data.get(Keys.GAME_MODE).orElse(null);
        this.impl$difficulty = data.get(Keys.WORLD_DIFFICULTY).orElse(null);
        this.impl$serializationBehavior = data.getOrElse(Keys.SERIALIZATION_BEHAVIOR, SerializationBehavior.AUTOMATIC);
        this.impl$displayName = data.getOrNull(Keys.DISPLAY_NAME);
        this.impl$viewDistance = data.getOrNull(Keys.VIEW_DISTANCE);
        this.impl$spawnPosition = data.getOrNull(Keys.SPAWN_POSITION);
        this.impl$loadOnStartup = data.getOrElse(Keys.IS_LOAD_ON_STARTUP, true);
        this.impl$performsSpawnLogic = data.getOrElse(Keys.PERFORM_SPAWN_LOGIC, false);
        this.impl$hardcore = data.getOrNull(Keys.HARDCORE);
        this.impl$commands = data.getOrNull(Keys.COMMANDS);
        this.impl$pvp = data.getOrNull(Keys.PVP);
        this.impl$seed = data.getOrNull(Keys.SEED);
        return (LevelStem)this;
    }

    @Override
    public SpongeWorldTemplate.SpongeDataSection bridge$createData() {
        return new SpongeWorldTemplate.SpongeDataSection(this.bridge$displayName(), this.impl$gameMode, this.impl$difficulty, this.impl$serializationBehavior, this.impl$viewDistance, this.impl$spawnPosition, this.impl$loadOnStartup, this.impl$performsSpawnLogic, this.impl$hardcore, this.impl$commands, this.impl$pvp, this.impl$seed);
    }
}

