/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.ticks;

import com.google.common.base.Preconditions;
import java.time.Duration;
import net.kyori.adventure.util.Ticks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.ScheduledTick;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.ticks.LevelTicksBridge;
import org.spongepowered.common.bridge.world.ticks.TickNextTickDataBridge;

@Mixin(value={ScheduledTick.class})
public abstract class ScheduledTickMixin<T>
implements TickNextTickDataBridge<T> {
    @Shadow
    @Final
    private BlockPos pos;
    @Shadow
    @Final
    private long triggerTick;
    private @MonotonicNonNull ServerLocation impl$location;
    private @MonotonicNonNull LevelTicks<T> impl$parentTickList;
    private long impl$scheduledTime;
    private ScheduledUpdate.State impl$state = ScheduledUpdate.State.WAITING;

    @Override
    public void bridge$createdByList(LevelTicks<T> tickList) {
        this.impl$parentTickList = tickList;
        this.impl$scheduledTime = ((LevelTicksBridge)tickList).bridge$getGameTime().getAsLong();
    }

    @Override
    public void bridge$setWorld(Level world) {
        Preconditions.checkState((this.impl$location == null ? 1 : 0) != 0, (Object)"World already known");
        BlockPos position = this.pos;
        this.impl$location = ServerLocation.of((ServerWorld)world, position.getX(), position.getY(), position.getZ());
    }

    @Override
    public ServerLocation bridge$getLocation() {
        Preconditions.checkState((this.impl$location != null ? 1 : 0) != 0, (Object)"Unable to determine location at this time");
        return this.impl$location;
    }

    @Override
    public ScheduledUpdate.State bridge$internalState() {
        if (this.impl$parentTickList == null) {
            return ScheduledUpdate.State.CANCELLED;
        }
        return this.impl$state;
    }

    @Override
    public void bridge$setState(ScheduledUpdate.State state) {
        this.impl$state = state;
    }

    @Override
    public boolean bridge$cancelForcibly() {
        if (this.impl$parentTickList == null) {
            return false;
        }
        if (this.impl$state == ScheduledUpdate.State.FINISHED) {
            return false;
        }
        this.impl$state = ScheduledUpdate.State.CANCELLED;
        return true;
    }

    @Override
    public Duration bridge$getScheduledDelayWhenCreated() {
        return Ticks.duration((long)(this.triggerTick - this.impl$scheduledTime));
    }
}

