/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.MultiBlockCarrier;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.inventory.DefaultSingleBlockCarrier;

@Mixin(value={CompoundContainer.class})
public abstract class CompoundContainerMixin_Carrier_Inventory_API
implements MultiBlockCarrier {
    @Shadow
    @Final
    private Container container1;
    @Shadow
    @Final
    private Container container2;

    @Override
    public List<ServerLocation> locations() {
        ArrayList<ServerLocation> list = new ArrayList<ServerLocation>();
        if (this.container1 instanceof BlockEntity) {
            list.add(((BlockEntity)this.container1).serverLocation());
        }
        if (this.container2 instanceof BlockEntity) {
            list.add(((BlockEntity)this.container2).serverLocation());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public CarriedInventory<? extends Carrier> inventory() {
        return (CarriedInventory)((Object)this);
    }

    public ServerLocation location() {
        return this.locations().get(0);
    }

    @Override
    public Optional<Inventory> inventory(ServerLocation at) {
        if (this.locations().contains(at)) {
            return Optional.of(this.inventory());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Inventory> inventory(ServerLocation at, Direction from) {
        return this.inventory(at);
    }

    @Override
    public Inventory inventory(Direction from) {
        return DefaultSingleBlockCarrier.inventory(from, this);
    }
}

