/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.world.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.bridge.world.inventory.LensGeneratorBridge;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_EquipmentFabric_Inventory
implements Fabric,
InventoryBridge,
LensGeneratorBridge {
    private static final int MAX_STACK_SIZE = 64;

    @Shadow
    public abstract ItemStack shadow$getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract void shadow$setItemSlot(EquipmentSlot var1, ItemStack var2);

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        return Collections.singleton(this);
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        return this;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.shadow$getItemBySlot(EquipmentSlot.values()[index]);
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.shadow$setItemSlot(EquipmentSlot.values()[index], stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return 64;
    }

    @Override
    public int fabric$getSize() {
        return EquipmentSlot.values().length;
    }

    @Override
    public void fabric$clear() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.shadow$setItemSlot(slot, ItemStack.EMPTY);
        }
    }

    @Override
    public void fabric$markDirty() {
    }

    @Override
    public SlotLensProvider lensGeneratorBridge$generateSlotLensProvider() {
        return new LensRegistrar.BasicSlotLensProvider(this.fabric$getSize());
    }

    @Override
    public Lens lensGeneratorBridge$generateLens(SlotLensProvider slotLensProvider) {
        LinkedHashMap<EquipmentType, SlotLens> equipmentLenses = new LinkedHashMap<EquipmentType, SlotLens>();
        int slotsLength = EquipmentSlot.values().length;
        for (int i = 0; i < slotsLength; ++i) {
            EquipmentSlot slot = EquipmentSlot.values()[i];
            equipmentLenses.put((EquipmentType)slot, slotLensProvider.getSlotLens(i));
        }
        return new EquipmentInventoryLens(equipmentLenses);
    }
}

