/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.resourcepack.SpongeResourcePack;

public final class SpongeWorldResourcePack
extends SpongeResourcePack {
    private final String path;
    private final URI uri;
    public static final String LEVEL_PACK_PROTOCOL = "level://";

    public SpongeWorldResourcePack(String levelUri, @Nullable String hash, Component component) {
        super(hash, component);
        this.path = levelUri.substring(LEVEL_PACK_PROTOCOL.length());
        try {
            this.uri = URI.create(LEVEL_PACK_PROTOCOL + URLEncoder.encode(this.path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SpongeWorldResourcePack(URI levelUri, @Nullable String hash, Component component) {
        super(hash, component);
        String path = levelUri.toString().substring(LEVEL_PACK_PROTOCOL.length());
        try {
            this.path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        this.uri = levelUri;
    }

    @Override
    public String name() {
        return "resourceszip";
    }

    @Override
    public String getUrlString() {
        return LEVEL_PACK_PROTOCOL + this.path;
    }

    @Override
    public URI uri() {
        return this.uri;
    }
}

