/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;

public final class PerWorldBorderListener
implements BorderChangeListener {
    private final ServerLevel world;

    public PerWorldBorderListener(ServerLevel world) {
        this.world = world;
    }

    public void onBorderSizeSet(WorldBorder border, double newSize) {
        this.sendWorldBorderActionPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderSizePacket(border));
    }

    public void onBorderSizeLerping(WorldBorder border, double oldSize, double newSize, long time) {
        this.sendWorldBorderActionPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderLerpSizePacket(border));
    }

    public void onBorderCenterSet(WorldBorder border, double x, double z) {
        this.sendWorldBorderActionPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderCenterPacket(border));
    }

    public void onBorderSetWarningTime(WorldBorder border, int newTime) {
        this.sendWorldBorderActionPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderWarningDelayPacket(border));
    }

    public void onBorderSetWarningBlocks(WorldBorder border, int newDistance) {
        this.sendWorldBorderActionPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderWarningDistancePacket(border));
    }

    public void onBorderSetDamagePerBlock(WorldBorder border, double newAmount) {
    }

    public void onBorderSetDamageSafeZOne(WorldBorder border, double newSize) {
    }

    private void sendWorldBorderActionPacket(Packet<ClientGamePacketListener> packet) {
        this.world.players().forEach(player -> player.connection.send(packet));
    }
}

