/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeCheckerboardBiomeConfig
extends AbstractBiomeProviderConfig
implements CheckerboardBiomeConfig {
    private final int scale;

    public SpongeCheckerboardBiomeConfig(BuilderImpl builder) {
        super(builder.biomes);
        this.scale = builder.scale;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    public static final class BuilderImpl
    implements CheckerboardBiomeConfig.Builder {
        public List<RegistryReference<Biome>> biomes = new ArrayList<RegistryReference<Biome>>();
        public int scale;

        @Override
        public CheckerboardBiomeConfig.Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public CheckerboardBiomeConfig.Builder addBiome(RegistryReference<Biome> biome) {
            this.biomes.add(Objects.requireNonNull(biome, "biome"));
            return this;
        }

        @Override
        public CheckerboardBiomeConfig.Builder addBiomes(List<RegistryReference<Biome>> biomes) {
            this.biomes.addAll((Collection<RegistryReference<Biome>>)Objects.requireNonNull(biomes, "biomes"));
            return this;
        }

        @Override
        public CheckerboardBiomeConfig.Builder removeBiome(RegistryReference<Biome> biome) {
            Objects.requireNonNull(biome, "biome");
            Iterator<RegistryReference<Biome>> iter = this.biomes.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(biome)) continue;
                iter.remove();
                break;
            }
            return this;
        }

        @Override
        public CheckerboardBiomeConfig.Builder reset() {
            this.biomes.clear();
            this.scale = 2;
            return this;
        }

        @Override
        public CheckerboardBiomeConfig.Builder from(CheckerboardBiomeConfig value) {
            this.biomes.clear();
            this.biomes.addAll(Objects.requireNonNull(value).biomes());
            this.scale = value.scale();
            return this;
        }

        public @NonNull CheckerboardBiomeConfig build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("Checkerboard biome config requires at least one biome!");
            }
            if (this.scale <= 0) {
                throw new IllegalStateException("Checkerboard biome config scale must be 1 or greater!");
            }
            return new SpongeCheckerboardBiomeConfig(this);
        }
    }
}

