/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import java.util.Objects;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeWorldGenerationConfigBuilder
implements WorldGenerationConfig.Builder {
    private long seed;
    private boolean generateFeatures;
    private boolean generateBonusChest;

    @Override
    public WorldGenerationConfig.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public void seed(String seed) {
        this.seed = SeedUtil.compute(seed);
    }

    @Override
    public WorldGenerationConfig.Builder generateStructures(boolean generateStructures) {
        this.generateFeatures = generateStructures;
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder generateBonusChest(boolean generateBonusChest) {
        this.generateBonusChest = generateBonusChest;
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder reset() {
        WorldOptions defaultSettings = SpongeCommon.server().getWorldData().worldGenOptions();
        this.seed = defaultSettings.seed();
        this.generateFeatures = defaultSettings.generateStructures();
        this.generateBonusChest = defaultSettings.generateBonusChest();
        return this;
    }

    @Override
    public WorldGenerationConfig.Builder from(WorldGenerationConfig value) {
        this.seed = Objects.requireNonNull(value, "value").seed();
        this.generateFeatures = value.generateStructures();
        this.generateBonusChest = value.generateBonusChest();
        return this;
    }

    public WorldGenerationConfig build() {
        return (WorldGenerationConfig)new WorldOptions(this.seed, this.generateFeatures, this.generateBonusChest);
    }
}

